/*
 * Copyright 2009 University of Zurich, Switzerland
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.evolizer.versioncontrol.ui.wizards;

import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * Wizard to guide the user through the process of importing contents from
 * CVS into the RHDB.
 * 
 * @author giger
 */
public class MissingSourceCodeWizard extends Wizard {

    private MissingFileContentPage page;
    private boolean canceled;
    private boolean reImport;
    private String fileExtensionRegEx;

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean performFinish() {
        reImport = page.isReImportEnabled();
        fileExtensionRegEx = page.getFileExtensionRegEx();
        return true;
    }

    /**
     * Returns the file extension regex.
     * 
     * @return the file extension regex
     */
    public String getFileExtensionRegEx() {
        return fileExtensionRegEx;
    }

    /**
     * Checks if is re import enabled.
     * 
     * @return <code>true</code> if is re import enabled, <code>false</code> otherwise
     */
    public boolean isReImportEnabled() {
        return reImport;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addPages() {
        page = new MissingFileContentPage("File Content Importer");
        page.setTitle("Import File Content for Versioning Model");
        page.setDescription("Re-import file content or complete file content for an existing versioning model.");

        addPage(page);
    }

    /**
     * Checks if is canceled.
     * 
     * @return <code>true</code> if is canceled, <code>false</code> otherwise
     */
    public boolean isCanceled() {
        return canceled;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean performCancel() {
        canceled = true;
        return super.performCancel();
    }

    private class MissingFileContentPage extends WizardPage {

        private Button reImportButton;
        private Label regExLabel;
        private Text fileExtensionText;

        protected MissingFileContentPage(String pageName) {
            super(pageName);
        }

        public boolean isReImportEnabled() {
            return reImportButton.getSelection();
        }

        public String getFileExtensionRegEx() {
            return fileExtensionText.getText();
        }

        public void createControl(Composite parent) {

            Composite mainComposite = new Composite(parent, SWT.NONE);

            GridLayout mainGridLayout = new GridLayout();
            mainComposite.setLayout(mainGridLayout);
            mainGridLayout.numColumns = 2;

            reImportButton = new Button(mainComposite, SWT.CHECK);

            GridData statusGridData = new GridData(GridData.FILL_HORIZONTAL);
            statusGridData.horizontalSpan = 2;
            reImportButton.setLayoutData(statusGridData);
            reImportButton.setText("Re-Import All");
            reImportButton.setSelection(false);

            regExLabel = new Label(mainComposite, SWT.NONE);
            regExLabel.setText("File Extension:");

            fileExtensionText = new Text(mainComposite, SWT.BORDER);
            GridData fileExtensionGridData = new GridData(GridData.FILL_HORIZONTAL);
            fileExtensionText.setLayoutData(fileExtensionGridData);
            fileExtensionText.setText("*");

            setControl(mainComposite);
        }
    }
}
