/*
 * Copyright 2009 University of Zurich, Switzerland
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.evolizer.changedistiller.ui.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.evolizer.changedistiller.job.ChangeDistiller;

/**
 * Action to be performed when selecting the change distilling action from the context menu.
 * 
 * @author fluri
 */
public class ChangeDistillerAction extends AbstractHandler {

    /**
     * {@inheritDoc}
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (HandlerUtil.getCurrentSelection(event) instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection) HandlerUtil.getCurrentSelection(event);

            List<IJavaElement> elements = new LinkedList<IJavaElement>();
            for (Iterator<?> iterator = selection.iterator(); iterator.hasNext();) {
                Object element = iterator.next();
                if (element instanceof IJavaElement) {
                    elements.add((IJavaElement) element);
                }
            }
            ChangeDistiller handler = new ChangeDistiller();
            handler.process(elements.toArray(new IJavaElement[]{}));
        }
        return null;
    }
}
