public class OrdersListComponent {
	protected void addSelf(PluginModel model, JAR jar, List classpath, String location, List pluginChain) throws CoreException {
		// If model is a fragment, we need to add in the classpath the plugin to which it is related
		if (model instanceof PluginFragmentModel) {
			PluginModel plugin = getRegistry().getPlugin(((PluginFragmentModel) model).getPlugin());
			addPluginAndPrerequisites(plugin, classpath, location, pluginChain);
		}	
		
		// Add the libraries
		Properties modelProperties = getBuildProperties(model);
		String jarOrder = (String) modelProperties.get(PROPERTY_JAR_ORDER);
		if (jarOrder == null) {
			// if no jar order was specified in build.properties, we add all the libraries but the current one
			// based on the order specified by the plugin.xml. Both library that we compile and .jar provided are processed
			LibraryModel[] libraries = model.getRuntime();
			if (libraries != null) {
				for (int i = 0; i < libraries.length; i++) {
					String libraryName = libraries[i].getName();
					if (jar.getName().equals(libraryName))
						continue;
		
					boolean isSource = (modelProperties.getProperty(PROPERTY_SOURCE_PREFIX + libraryName) != null);
					if (isSource) {
						addDevEntries(model, location, classpath, (String[]) Utils.getArrayFromString(modelProperties.getProperty(PROPERTY_OUTPUT_PREFIX + libraryName)));
					}
					//Potential pb: here there maybe a nasty case where the libraries variable may refer to something which is part of the base
					//but $xx$ will replace it by the $xx instead of $basexx. The solution is for the user to use the explicitly set the content
					// of its build.property file
					addPathAndCheck(libraryName, classpath);
				}
			}
		} else {
			// otherwise we add all the predecessor jars
			String[] order = Utils.getArrayFromString(jarOrder);
			for (int i = 0; i < order.length; i++) {
				if (order[i].equals(jar.getName()))
					break;
				addDevEntries(model, location, classpath, (String[]) Utils.getArrayFromString((String) modelProperties.get(PROPERTY_OUTPUT_PREFIX + order[i])));
				addPathAndCheck(order[i], classpath);
			}
			// Then we add all the "pure libraries" (the one that does not contain source)
			LibraryModel[] libraries = model.getRuntime();
			for (int i = 0; i < libraries.length; i++) {
				String libraryName = libraries[i].getName();
				if (modelProperties.get(PROPERTY_SOURCE_PREFIX + libraryName) == null) {
					//Potential pb: if the pure library is something that is being compiled (which is supposetly not the case, but who knows...)
					//the user will get $basexx instead of $ws 
					addPathAndCheck(libraryName, classpath);
				}
			}
		}

		// add extra classpath if it exists. this code is kept for backward compatibility
		String extraClasspath = (String) modelProperties.get(PROPERTY_JAR_EXTRA_CLASSPATH);
		if (extraClasspath != null) {
			String[] extra = Utils.getArrayFromString(extraClasspath, ";,"); //$NON-NLS-1$
			
			for (int i = 0; i < extra.length; i++) {
				//Potential pb: if the path refers to something that is being compiled (which is supposetly not the case, but who knows...)
				//the user will get $basexx instead of $ws 
				addPathAndCheck(computeExtraPath(extra[i], location), classpath);
			}	 
		}

		//	add extra classpath if it is specified for the given jar
		String[] jarSpecificExtraClasspath = (String[]) jar.getExtraClasspath();
		for (int i = 0; i < jarSpecificExtraClasspath.length; i++) {
			//Potential pb: if the path refers to something that is being compiled (which is supposetly not the case, but who knows...)
			//the user will get $basexx instead of $ws 
			addPathAndCheck(computeExtraPath(jarSpecificExtraClasspath[i], location), classpath); 
		}
	}
}