package org.argouml.xml.argo;

import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;
import org.argouml.kernel.OpenException;
import org.argouml.kernel.Project;
import org.argouml.ui.ArgoDiagram;
import org.argouml.xml.pgml.PGMLParser;

/**
 * The file persister for the diagram members.
 * @author Bob Tarling
 */
public class DiagramMemberFilePersister extends MemberFilePersister {
    
    /** logger */
    private static final Logger LOG =
        Logger.getLogger(ModelMemberFilePersister.class);
    
    /**
     * @see org.argouml.xml.argo.MemberFilePersister#load(org.argouml.kernel.Project,
     * java.io.InputStream)
     */
    public void load(Project project, InputStream inputStream)
        throws OpenException {
        
        try {
            PGMLParser parser = new PGMLParser();
            parser.setOwnerRegistry(project.getUUIDRefs());
            ArgoDiagram d =
                    (ArgoDiagram) parser.readDiagram(
                                  inputStream,
                                  false);
            inputStream.close();
            if (d != null) {
                project.addMember(d);
            }
            else {
                LOG.error("An error occurred while loading PGML");
            }
        } catch (IOException e) {
            throw new OpenException(e);
        }
    }
    
    /**
     * @see org.argouml.xml.argo.MemberFilePersister#getTag()
     */
    public String getMainTag() {
        return "pgml";
    }
}
