package org.argouml.xml.argo;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

import org.apache.log4j.Logger;
import org.argouml.kernel.OpenException;
import org.argouml.kernel.Project;
import org.argouml.ui.ArgoDiagram;
import org.argouml.xml.pgml.PGMLParser;
import org.xml.sax.SAXException;

/**
 * The file persister for the diagram members.
 * @author Bob Tarling
 */
public class DiagramMemberFilePersister extends MemberFilePersister {
    
    /** logger */
    private static final Logger LOG =
        Logger.getLogger(ModelMemberFilePersister.class);
    
    private InputStream inputStream;
    
    private Project project;
    private Map attributes;
    
    private static final String ROOT_TAG = "pgml";
    
    /**
     * The constructor.
     * 
     * @param theUrl the location where the diagram members 
     *               are stored persistently
     * @param theProject the project to persist
     * @throws SAXException when SAX finds a problem
     */
    public DiagramMemberFilePersister(Project theProject,
                                      InputStream inputStream) {
        this.project = theProject;
        this.inputStream = inputStream;
    }
        
    /**
     * @see org.argouml.xml.argo.MemberFilePersister#load(java.util.Map)
     */
    public void load() throws OpenException {
        try {
            PGMLParser parser = new PGMLParser();
            parser.setOwnerRegistry(project.getUUIDRefs());
            ArgoDiagram d =
                    (ArgoDiagram) parser.readDiagram(
                                  inputStream,
                                  false);
            inputStream.close();
            if (d != null) {
                project.addMember(d);
            }
            else {
                LOG.error("An error occurred while loading PGML");
            }
        } catch (IOException e) {
            throw new OpenException(e);
        }
    }
    
    /**
     * @see org.argouml.xml.argo.MemberFilePersister#getTag()
     */
    public String getTag() {
        return ROOT_TAG;
    }
}
