package org.evolizer.changedistiller.test.scchange;

import java.util.ArrayList;
import java.util.List;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SmallTreeTest extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/small_tree/";
        UNIQUE_NAME = "test.Test";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();

        fExpectedChanges = new ArrayList<SourceCodeChange>();
        fExpectedChanges.add(createInsertOperation(
                ChangeType.STATEMENT_INSERT,
                "test.Test.aMethod()",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                "1.2",
                "System.out.println(\"test_string_new_string_which_is_to_long_to_match_even_for_DiceNgrams\");",
                EntityType.METHOD_INVOCATION,
                0,
                115,
                96,
                "aString.equals(\"test_string\")",
                EntityType.THEN_STATEMENT,
                0,
                110,
                106));
        fExpectedChanges.add(createDeleteOperation(
                ChangeType.STATEMENT_DELETE,
                "test.Test.aMethod()",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                "1.2",
                "System.out.println(\"test_string\");",
                EntityType.METHOD_INVOCATION,
                0,
                115,
                33,
                "aString.equals(\"test_string\")",
                EntityType.THEN_STATEMENT,
                0,
                110,
                43));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }

    @Test
    public void testChanges() throws Exception {
        List<SourceCodeChange> result = fDJob.getSourceCodeChanges();
        checkChanges(result, 2, 0);
    }
}
