package org.evolizer.changedistiller.test.scchange;

import static org.evolizer.changedistiller.model.classifiers.SignificanceLevel.CRUCIAL;
import static org.evolizer.changedistiller.model.classifiers.SignificanceLevel.HIGH;
import static org.junit.Assert.assertEquals;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.SignificanceLevel;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.model.entities.Update;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SignificanceLiftTest extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/significance_lifting/";
        UNIQUE_NAME = "test.Test";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }

    @Test
    public void testSignificanceLevel() {
        int[] changes = new int[ChangeType.values().length];
        for (SourceCodeChange change : fDJob.getSourceCodeChanges()) {
            SignificanceLevel expected = null;
            changes[change.getChangeType().ordinal()]++;
            switch (change.getChangeType()) {
                case ATTRIBUTE_RENAMING:
                    expected = getHigh((Update) change);
                    break;
                case ATTRIBUTE_TYPE_CHANGE:
                    expected = getCrucialRootEntity(change);
                    break;
                case CLASS_RENAMING:
                    expected = getHigh((Update) change);
                    break;
                case DECREASING_ACCESSIBILITY_CHANGE:
                    expected = getCrucialChangedEntity(change);
                    break;
                case METHOD_RENAMING:
                    expected = getHigh((Update) change);
                    break;
                case PARAMETER_DELETE:
                    expected = getCrucialRootEntity(change);
                    break;
                case PARAMETER_INSERT:
                    expected = getCrucialRootEntity(change);
                    break;
                case PARAMETER_ORDERING_CHANGE:
                    expected = getCrucialRootEntity(change);
                    break;
                case PARAMETER_TYPE_CHANGE:
                    expected = getCrucialRootEntity(change);
                    break;
                case REMOVED_CLASS:
                    expected = getCrucialChangedEntity(change);
                    break;
                case REMOVED_FUNCTIONALITY:
                    expected = getCrucialChangedEntity(change);
                    break;
                case REMOVED_OBJECT_STATE:
                    expected = getCrucialChangedEntity(change);
                    break;
                case REMOVING_ATTRIBUTE_MODIFIABILITY:
                    expected = getCrucialRootEntity(change);
                    break;
                case RETURN_TYPE_CHANGE:
                    expected = getCrucialRootEntity(change);
                    break;
                case RETURN_TYPE_DELETE:
                    expected = getCrucialRootEntity(change);
                    break;
                case RETURN_TYPE_INSERT:
                    expected = getCrucialRootEntity(change);
                    break;
            }
            if (expected != null) {
                assertEquals(change.toString(), expected, change.getSignificanceLevel());
            }
        }
        // check occurrences of changes
        assertEquals(4, changes[ChangeType.ATTRIBUTE_RENAMING.ordinal()]);
        assertEquals(4, changes[ChangeType.ATTRIBUTE_TYPE_CHANGE.ordinal()]);
        assertEquals(4, changes[ChangeType.CLASS_RENAMING.ordinal()]);
        assertEquals(3, changes[ChangeType.DECREASING_ACCESSIBILITY_CHANGE.ordinal()]);
        assertEquals(4, changes[ChangeType.METHOD_RENAMING.ordinal()]);
        assertEquals(4, changes[ChangeType.PARAMETER_DELETE.ordinal()]);
        assertEquals(4, changes[ChangeType.PARAMETER_INSERT.ordinal()]);
        assertEquals(4, changes[ChangeType.PARAMETER_ORDERING_CHANGE.ordinal()]);
        assertEquals(4, changes[ChangeType.PARAMETER_TYPE_CHANGE.ordinal()]);
        assertEquals(4, changes[ChangeType.REMOVED_CLASS.ordinal()]);
        assertEquals(4, changes[ChangeType.REMOVED_FUNCTIONALITY.ordinal()]);
        assertEquals(4, changes[ChangeType.REMOVED_OBJECT_STATE.ordinal()]);
        assertEquals(4, changes[ChangeType.REMOVING_ATTRIBUTE_MODIFIABILITY.ordinal()]);
        assertEquals(4, changes[ChangeType.RETURN_TYPE_CHANGE.ordinal()]);
        assertEquals(4, changes[ChangeType.RETURN_TYPE_DELETE.ordinal()]);
        assertEquals(4, changes[ChangeType.RETURN_TYPE_INSERT.ordinal()]);
    }

    private SignificanceLevel getCrucialChangedEntity(SourceCodeChange change) {
        if (change.getChangedEntity().isProtected() || change.getChangedEntity().isPublic()) {
            return CRUCIAL;
        }
        return change.getSignificanceLevel();
    }

    private SignificanceLevel getHigh(Update update) {
        if (update.getNewEntity().isProtected() || update.getNewEntity().isPublic()) {
            return HIGH;
        }
        return update.getSignificanceLevel();
    }

    private SignificanceLevel getCrucialRootEntity(SourceCodeChange change) {
        if (change.getRootEntity().isProtected() || change.getRootEntity().isPublic()) {
            return CRUCIAL;
        }
        return change.getSignificanceLevel();
    }
}
