package org.evolizer.changedistiller.test.scchange;

import java.util.ArrayList;
import java.util.List;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class RenamingTest extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/renaming/";
        UNIQUE_NAME = "test.Test";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();

        fExpectedChanges = new ArrayList<SourceCodeChange>();
        fExpectedChanges.add(createUpdateOperation(
                ChangeType.STATEMENT_UPDATE,
                "test.Test.aMethod(String)",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                "1.2",
                "DrawVerticalAction dva=new DrawVerticalAction(actionName);",
                EntityType.VARIABLE_DECLARATION_STATEMENT,
                0,
                217,
                60,
                "test.Test.aMethod(String)",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                174,
                120,
                "VerticalDrawAction vdAction=new VerticalDrawAction(actionName);",
                EntityType.VARIABLE_DECLARATION_STATEMENT,
                0,
                219,
                65));

        fExpectedChanges.add(createInsertOperation(
                ChangeType.STATEMENT_INSERT,
                "test.Test.aMethod(String)",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                "1.2",
                "vdAction.draw();",
                EntityType.METHOD_INVOCATION,
                0,
                287,
                15,
                "test.Test.aMethod(String)",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                174,
                120));

        fExpectedChanges.add(createDeleteOperation(
                ChangeType.STATEMENT_DELETE,
                "test.Test.aMethod(String)",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                "1.2",
                "dva.draw();",
                EntityType.METHOD_INVOCATION,
                0,
                280,
                10,
                "test.Test.aMethod(String)",
                EntityType.METHOD,
                ChangeModifier.PUBLIC,
                174,
                120));

        SourceCodeChange tmp =
                createUpdateOperation(
                        ChangeType.METHOD_RENAMING,
                        "test.Test.printVerticalBar()",
                        EntityType.METHOD,
                        ChangeModifier.PUBLIC,
                        "1.2",
                        "verticalBarPrint",
                        EntityType.METHOD_DECLARATION,
                        ChangeModifier.PUBLIC,
                        104,
                        67,
                        "test.Test",
                        EntityType.CLASS,
                        ChangeModifier.PUBLIC,
                        26,
                        270,
                        "printVerticalBar",
                        EntityType.METHOD_DECLARATION,
                        ChangeModifier.PUBLIC,
                        106,
                        67);
        fExpectedChanges.add(tmp);

        fExpectedChanges.add(createUpdateOperation(
                ChangeType.ATTRIBUTE_RENAMING,
                "test.Test.nameOfTreeDifferencingAlgorithm : String",
                EntityType.ATTRIBUTE,
                ChangeModifier.PRIVATE,
                "1.2",
                "treeDifferencersAlgorithmName",
                EntityType.FIELD_DECLARATION,
                ChangeModifier.PRIVATE,
                47,
                54,
                "test.Test",
                EntityType.CLASS,
                ChangeModifier.PUBLIC,
                26,
                270,
                "nameOfTreeDifferencingAlgorithm",
                EntityType.FIELD_DECLARATION,
                ChangeModifier.PRIVATE,
                47,
                56));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }

    @Test
    public void testChanges() throws Exception {
        List<SourceCodeChange> result = fDJob.getSourceCodeChanges();
        checkChanges(result, 5, 0);
    }
}