package org.evolizer.changedistiller.test.scchange;

import static org.junit.Assert.assertEquals;

import java.util.List;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ParameterTypeChangeTest extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/parameter_type_change/";
        UNIQUE_NAME = "test.Test";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }

    @Test
    public void testChanges() throws Exception {
        List<SourceCodeChange> result = fDJob.getSourceCodeChanges();
        assertEquals(1, result.size());
        assertEquals(ChangeType.PARAMETER_TYPE_CHANGE, result.get(0).getChangeType());
    }

}
