package org.evolizer.changedistiller.test.scchange;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.evolizer.changedistiller.distilling.Distiller;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.Insert;
import org.evolizer.changedistiller.model.entities.Move;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.changedistiller.model.entities.Update;
import org.evolizer.changedistiller.test.Activator;
import org.evolizer.core.util.projecthandling.JavaProjectHelper;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;
import org.junit.AfterClass;
import org.junit.BeforeClass;

@SuppressWarnings("restriction")
public abstract class AbstractDistillerTest {

    private static JavaProjectHelper fHelper;
    private static IJavaProject fJProject = null;
    protected static IFolder fFolder = null;
    protected static Distiller fDJob = null;
    protected static String TEST_FOLDER = null;
    protected static String UNIQUE_NAME = null;
    protected static int MODIFIERS = -1;
    protected static List<SourceCodeChange> fExpectedChanges = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        // creating an empty dummy Java project
        fHelper = new JavaProjectHelper();
        fHelper.createProject("TestProject", "bin", new NullProgressMonitor());

        // creating a folder for the files to compare
        fHelper.addStandartSourceFolder(new NullProgressMonitor());
        fHelper.addPackage("", new NullProgressMonitor());
        fJProject = fHelper.getJavaProject();
        assertNotNull(fJProject);
        fFolder = fJProject.getProject().getFolder("folder");
        CoreUtility.createFolder(fFolder, true, true, null);

        // performing a comparison
        IFile left = fFolder.getFile("1_1.java");
        left.create(Activator.openBundledFile(TEST_FOLDER + "TestLeft.java"), true, null);
        IFile right = fFolder.getFile("1_2.java");
        right.create(Activator.openBundledFile(TEST_FOLDER + "TestRight.java"), true, null);

        fDJob = new Distiller();
        fDJob.performDistilling(left, right);
        fDJob.getClassHistory().updateLatestVersionWithRevision(new Revision("1.2"));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        fHelper.deleteWorkspace(true, true, new NullProgressMonitor());
    }

    protected boolean containsChangeType(List<? extends SourceCodeChange> sccs, ChangeType changeType) {
        for (SourceCodeChange scc : sccs) {
            if (scc.getChangeType() == changeType) {
                return true;
            }
        }
        return false;
    }

    protected boolean containsOperation(SourceCodeChange expected, List<SourceCodeChange> cos) {
        for (SourceCodeChange op : cos) {
            if (expected.equals(op)) {
                return true;
            }
        }
        return false;
    }

    protected static Insert createInsertOperation(
            ChangeType changeType,
            String structureEntityName,
            EntityType structureEntityType,
            int structureEntityModifiers,
            String revisionNumber,
            String entityName,
            EntityType entityType,
            int entityModifiers,
            int entityOffset,
            int entityLength,
            String parentName,
            EntityType parentType,
            int parentModifiers,
            int parentOffset,
            int parentLength) {
        return new Insert(changeType, createStructureEntityVersion(
                structureEntityName,
                structureEntityType,
                structureEntityModifiers,
                revisionNumber), new SourceCodeEntity(entityName, entityType, entityModifiers, new SourceRange(
                entityOffset,
                entityLength)), new SourceCodeEntity(parentName, parentType, parentModifiers, new SourceRange(
                parentOffset,
                parentLength)));
    }

    private static StructureEntityVersion createStructureEntityVersion(
            String structureEntityName,
            EntityType structureEntityType,
            int structureEntityModifiers,
            String revisionNumber) {
        StructureEntityVersion result =
                new StructureEntityVersion(structureEntityType, structureEntityName, structureEntityModifiers);
        result.setRevision(new Revision(revisionNumber));
        return result;
    }

    protected static Delete createDeleteOperation(
            ChangeType changeType,
            String structureEntityName,
            EntityType structureEntityType,
            int structureEntityModifiers,
            String revisionNumber,
            String entityName,
            EntityType entityType,
            int entityModifiers,
            int entityOffset,
            int entityLength,
            String parentName,
            EntityType parentType,
            int parentModifiers,
            int parentOffset,
            int parentLength) {
        return new Delete(changeType, createStructureEntityVersion(
                structureEntityName,
                structureEntityType,
                structureEntityModifiers,
                revisionNumber), new SourceCodeEntity(entityName, entityType, entityModifiers, new SourceRange(
                entityOffset,
                entityLength)), new SourceCodeEntity(parentName, parentType, parentModifiers, new SourceRange(
                parentOffset,
                parentLength)));
    }

    protected static Move createMoveOperation(
            ChangeType changeType,
            String structureEntityName,
            EntityType structureEntityType,
            int structureEntityModifiers,
            String revisionNumber,
            String entityName,
            EntityType entityType,
            int entityModifiers,
            int entityOffset,
            int entityLength,
            int changedOffset,
            int changedLength,
            String oldParentName,
            EntityType oldParentType,
            int oldParentModifiers,
            int oldOffset,
            int oldLength,
            String newParentName,
            EntityType newParentType,
            int newParentModifiers,
            int newParentOffset,
            int newParentLength) {
        return new Move(changeType, createStructureEntityVersion(
                structureEntityName,
                structureEntityType,
                structureEntityModifiers,
                revisionNumber), new SourceCodeEntity(entityName, entityType, entityModifiers, new SourceRange(
                entityOffset,
                entityLength)), new SourceCodeEntity(entityName, entityType, entityModifiers, new SourceRange(
                changedOffset,
                changedLength)), new SourceCodeEntity(
                oldParentName,
                oldParentType,
                oldParentModifiers,
                new SourceRange(oldOffset, oldLength)), new SourceCodeEntity(
                newParentName,
                newParentType,
                newParentModifiers,
                new SourceRange(newParentOffset, newParentLength)));
    }

    protected static Update createUpdateOperation(
            ChangeType changeType,
            String structureEntityName,
            EntityType structureEntityType,
            int structureEntityModifiers,
            String revisionNumber,
            String entityName,
            EntityType entityType,
            int entityModifiers,
            int entityOffset,
            int entityLength,
            String parentName,
            EntityType parentType,
            int parentModifiers,
            int parentOffset,
            int parentLength,
            String newName,
            EntityType newType,
            int newModifiers,
            int changedOffset,
            int changedLength) {
        return new Update(changeType, createStructureEntityVersion(
                structureEntityName,
                structureEntityType,
                structureEntityModifiers,
                revisionNumber), new SourceCodeEntity(entityName, entityType, entityModifiers, new SourceRange(
                entityOffset,
                entityLength)), new SourceCodeEntity(newName, newType, newModifiers, new SourceRange(
                changedOffset,
                changedLength)), new SourceCodeEntity(parentName, parentType, parentModifiers, new SourceRange(
                parentOffset,
                parentLength)));
    }

    protected void checkChanges(List<SourceCodeChange> result, int expSize, int expRest) {
        assertEquals(expSize, result.size());
        for (SourceCodeChange change : fExpectedChanges) {
            if (!result.remove(change)) {
                result.remove(change);
            }
        }
        assertEquals(expRest, result.size());
    }
}