package org.evolizer.changedistiller.test.commenttosourcemapping;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.Document;
import org.evolizer.changedistiller.jdt.ASTCommentVisitor;
import org.evolizer.changedistiller.jdt.ASTNodeToCommentCounter;
import org.evolizer.changedistiller.test.Activator;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class NodeToCommentCounterTest {

    private final String TEST_FOLDER = "./test_data/integration/";
    private Document fSource = null;
    private int[] matchingCounts = null;
    private int[] occurrenceCounts;

    @SuppressWarnings("unchecked")
    @Before
    public void setUp() throws Exception {
        String source = read(Activator.openBundledFile(TEST_FOLDER + "TestCommentToSource.java"));
        fSource = new Document(source);
        ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setSource(source.toCharArray());
        CompilationUnit cu = (CompilationUnit) parser.createAST(null);
        ASTCommentVisitor commentVisitor = new ASTCommentVisitor(fSource);
        Iterator<ASTNode> i = cu.getCommentList().iterator();
        while (i.hasNext()) {
            ASTNode commentNode = i.next();
            commentNode.accept(commentVisitor);
        }
        Vector<Comment> comments = commentVisitor.getComments();
        ASTNodeToCommentCounter counter = new ASTNodeToCommentCounter(cu, comments, fSource);
        cu.accept(counter);
        matchingCounts = counter.getNodeTypeCounts();
        occurrenceCounts = counter.getNodeOccurrences();
    }

    @After
    public void tearDown() throws Exception {}

    @Test
    public void testNodeToCommentCounterTest() throws Exception {

        assertEquals(2, matchingCounts[ASTNode.TYPE_DECLARATION]);
        assertEquals(3, occurrenceCounts[ASTNode.TYPE_DECLARATION]);
        assertEquals(2, matchingCounts[ASTNode.FIELD_DECLARATION]);
        assertEquals(3, occurrenceCounts[ASTNode.FIELD_DECLARATION]);
        assertEquals(2, matchingCounts[ASTNode.METHOD_DECLARATION]);
        assertEquals(6, occurrenceCounts[ASTNode.METHOD_DECLARATION]);
        assertEquals(2, matchingCounts[ASTNode.VARIABLE_DECLARATION_STATEMENT]);
        assertEquals(5, occurrenceCounts[ASTNode.VARIABLE_DECLARATION_STATEMENT]);
        assertEquals(1, matchingCounts[ASTNode.IF_STATEMENT]);
        assertEquals(1, occurrenceCounts[ASTNode.IF_STATEMENT]);
        assertEquals(3, matchingCounts[ASTNode.ASSIGNMENT]);
        assertEquals(4, occurrenceCounts[ASTNode.ASSIGNMENT]);

        /*for (int i = 0; i < matchingCounts.length; i++) {
        	try {
        		System.out.println(ASTNode.nodeClassForType(i).getSimpleName() + ": " + matchingCounts[i]);
        	} catch (IllegalArgumentException e) {}
        }*/
    }

    private String read(InputStream stream) {
        InputStreamReader reader = new InputStreamReader(stream);
        StringBuffer sb = new StringBuffer();
        char[] b = new char[1024];
        int n;
        try {
            while ((n = reader.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            reader.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}
