package org.evolizer.changedistiller.test.bugs;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.entities.ClassHistory;
import org.evolizer.changedistiller.test.scchange.AbstractDistillerTest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class Bug63Test extends AbstractDistillerTest {

    private ClassHistory fClassHistory;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/bugs/63/";
        UNIQUE_NAME = "Bug63";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();
    }

    @Before
    public void setUp() {
        fClassHistory = fDJob.getClassHistory();
    }

    @Test
    public void testAttributeFormattingChange() {
        Assert.assertTrue(fClassHistory.getAttributeHistories().isEmpty());
    }

    @Test
    public void testInnerClassFormattingChange() {
        Assert.assertTrue(fClassHistory.getInnerClassHistories().isEmpty());
    }

    @Test
    public void testMethodFormattingChange() {
        Assert.assertTrue(fClassHistory.getMethodHistories().isEmpty());
    }

    @After
    public void tearDown() {
        fClassHistory = null;
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }

}
