package org.evolizer.changedistiller.test.bugs;

import junit.framework.Assert;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.Insert;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.model.entities.Update;
import org.evolizer.changedistiller.test.scchange.AbstractDistillerTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class Bug41Test extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/bugs/41/";
        UNIQUE_NAME = "Bug41";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();
    }

    @Test
    public void testReturnTypeChangeTypes() {
        Assert.assertEquals(6, fDJob.getSourceCodeChanges().size());
        for (SourceCodeChange scc : fDJob.getSourceCodeChanges()) {
            String root = scc.getRootEntity().getUniqueName();
            if (root.equals("test.Bug41.rtd1()")) {
                Assert.assertEquals(ChangeType.RETURN_TYPE_DELETE, scc.getChangeType());
                Assert.assertTrue(scc.getClass().getSimpleName(), scc instanceof Delete);
                Assert.assertEquals("test.Bug41.rtd1(): Object", scc.getChangedEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rtd1()", ((Delete) scc).getParentEntity().getUniqueName());
            } else if (root.equals("test.Bug41.rtd2()")) {
                Assert.assertEquals(ChangeType.RETURN_TYPE_DELETE, scc.getChangeType());
                Assert.assertTrue(scc.getClass().getSimpleName(), scc instanceof Delete);
                Assert.assertEquals("test.Bug41.rtd2(): int", scc.getChangedEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rtd2()", ((Delete) scc).getParentEntity().getUniqueName());
            } else if (root.equals("test.Bug41.rti1()")) {
                Assert.assertEquals(ChangeType.RETURN_TYPE_INSERT, scc.getChangeType());
                Assert.assertTrue(scc.getClass().getSimpleName(), scc instanceof Insert);
                Assert.assertEquals("test.Bug41.rti1(): Object", scc.getChangedEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rti1()", ((Insert) scc).getParentEntity().getUniqueName());
            } else if (root.equals("test.Bug41.rti2()")) {
                Assert.assertEquals(ChangeType.RETURN_TYPE_INSERT, scc.getChangeType());
                Assert.assertTrue(scc.getClass().getSimpleName(), scc instanceof Insert);
                Assert.assertEquals("test.Bug41.rti2(): int", scc.getChangedEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rti2()", ((Insert) scc).getParentEntity().getUniqueName());
            } else if (root.equals("test.Bug41.rtc1()")) {
                Assert.assertEquals(ChangeType.RETURN_TYPE_CHANGE, scc.getChangeType());
                Assert.assertTrue(scc.getClass().getSimpleName(), scc instanceof Update);
                Assert.assertEquals("test.Bug41.rtc1(): Obec", scc.getChangedEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rtc1(): Object", ((Update) scc).getNewEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rtc1()", ((Update) scc).getParentEntity().getUniqueName());
            } else if (root.equals("test.Bug41.rtc2()")) {
                Assert.assertEquals(ChangeType.RETURN_TYPE_CHANGE, scc.getChangeType());
                Assert.assertTrue(scc.getClass().getSimpleName(), scc instanceof Update);
                Assert.assertEquals("test.Bug41.rtc2(): L33t", scc.getChangedEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rtc2(): Uber", ((Update) scc).getNewEntity().getUniqueName());
                Assert.assertEquals("test.Bug41.rtc2()", ((Update) scc).getParentEntity().getUniqueName());
            }
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }

}
