package org.evolizer.changedistiller.test.bugs;

import static org.junit.Assert.assertEquals;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.test.scchange.AbstractDistillerTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * If a class is in the default package, its uniqueName has a leading dot (.). That is wrong...
 * 
 */
public class Bug16Test extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/bugs/16/";
        UNIQUE_NAME = "Bug16";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();
    }

    @Test
    public void testUniqueName() {
        SourceCodeChange change = fDJob.getSourceCodeChanges().get(0);
        assertEquals("Bug16.foo()", change.getRootEntity().getUniqueName());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }
}
