package org.evolizer.changedistiller.test.bugs;

import static org.junit.Assert.assertTrue;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.test.scchange.AbstractDistillerTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Instead of Parent Interface Change, the ChangeClassifier detects a Parent Class Change
 * 
 */
public class Bug10Test extends AbstractDistillerTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_FOLDER = "./test_data/bugs/10/";
        UNIQUE_NAME = "Bug10";
        MODIFIERS = ChangeModifier.PUBLIC;
        AbstractDistillerTest.setUpBeforeClass();
    }

    @Test
    public void testUniqueName() {
        assertTrue(fDJob.getSourceCodeChanges().size() == 2);
        int parentInterface = 0;
        int parentClass = 0;
        for (SourceCodeChange change : fDJob.getSourceCodeChanges()) {
            if (change.getChangeType() == ChangeType.PARENT_CLASS_CHANGE) {
                parentClass++;
            }
            if (change.getChangeType() == ChangeType.PARENT_INTERFACE_CHANGE) {
                parentInterface++;
            }
        }
        assertTrue(parentInterface == 1);
        assertTrue(parentClass == 1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractDistillerTest.tearDownAfterClass();
    }
}
