/*
 * Copyright 2009 University of Zurich, Switzerland
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.evolizer.changedistiller.model.classifiers;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Representation of a range in a document with offset and length.
 * 
 * @author fluri, zubi
 * 
 */
public final class SourceRange {

    private int fOffset = -1;
    private int fLength = -1;

    /**
     * Create a new {@link SourceRange}.
     * 
     * @param offset
     *            in the document
     * @param length
     *            of the range
     */
    public SourceRange(int offset, int length) {
        fOffset = offset;
        fLength = length;
    }

    /**
     * Creates new range with offset and length set to -1.
     */
    public SourceRange() {}

    /**
     * Returns the offset of this {@link SourceRange}.
     * 
     * @return offset of this range
     */
    public int getOffset() {
        return fOffset;
    }

    /**
     * Returns the length of this {@link SourceRange}.
     * 
     * @return length of this range
     */
    public int getLength() {
        return fLength;
    }

    /**
     * Sets offset of this {@link SourceRange}.
     * 
     * @param offset
     *            to set
     */
    public void setOffset(int offset) {
        fOffset = offset;
    }

    /**
     * Sets length of this {@link SourceRange}.
     * 
     * @param length
     *            to set
     */
    public void setLength(int length) {
        fLength = length;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        SourceRange other = (SourceRange) obj;
        return new EqualsBuilder().append(getOffset(), other.getOffset()).append(getLength(), other.getLength())
                .isEquals();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder(13, 31).append(getOffset()).append(getLength()).toHashCode();
    }
}
