/*
 * Copyright 2009 University of Zurich, Switzerland
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.evolizer.changedistiller.model;

import org.evolizer.changedistiller.model.entities.AbstractHistory;
import org.evolizer.changedistiller.model.entities.AttributeHistory;
import org.evolizer.changedistiller.model.entities.ClassHistory;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.Insert;
import org.evolizer.changedistiller.model.entities.MethodHistory;
import org.evolizer.changedistiller.model.entities.Move;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.changedistiller.model.entities.Update;
import org.evolizer.core.hibernate.model.api.IEvolizerModelProvider;

/**
 * Defines the persistent entities for change history meta-model.
 * 
 * @author fluri
 * 
 */
public class EvolizerChangeDistillerModelProvider implements IEvolizerModelProvider {

    /**
     * {@inheritDoc}
     */
    public Class<?>[] getAnnotatedClasses() {
        Class<?>[] annotatedClasses =
                {
                        AttributeHistory.class,
                        ClassHistory.class,
                        Delete.class,
                        AbstractHistory.class,
                        Insert.class,
                        MethodHistory.class,
                        Move.class,
                        SourceCodeChange.class,
                        SourceCodeEntity.class,
                        StructureEntityVersion.class,
                        Update.class};
        return annotatedClasses;
    }
}
