package org.evolizer.changedistiller.model.test;

import java.lang.reflect.Modifier;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.changedistiller.model.entities.Update;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class UpdateEqualsTest extends AbstractEqualsTest<Update> {

    @Override
    protected Update[] createEqualObjects() {
        Revision version = new Revision("1.0.0");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", Modifier.PUBLIC, version);
        SourceCodeEntity updated =
                new SourceCodeEntity("org.foo.bar.Imba.leet(String test)", EntityType.METHOD, new SourceRange(85, 59));
        SourceCodeEntity newEntity =
                new SourceCodeEntity("org.foo.bar.Imba.uber(String test)", EntityType.METHOD, new SourceRange(85, 59));
        SourceCodeEntity parent = new SourceCodeEntity("org.foo.bar.Imba", EntityType.CLASS, new SourceRange(0, 489));
        Update update = new Update(ChangeType.METHOD_RENAMING, rootEntity, updated, newEntity, parent);
        return new Update[]{update};
    }

    @Override
    protected Update createNotEqualObject() {
        Revision version = new Revision("1.0.0");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", Modifier.PUBLIC, version);
        SourceCodeEntity updated =
                new SourceCodeEntity(
                        "org.foo.bar.Imba.value : MyType",
                        EntityType.ATTRIBUTE,
                        ChangeModifier.PRIVATE,
                        new SourceRange(23, 5));
        SourceCodeEntity newEntity =
                new SourceCodeEntity(
                        "org.foo.bar.Imba.value : MyType",
                        EntityType.ATTRIBUTE,
                        ChangeModifier.PROTECTED,
                        new SourceRange(23, 5));
        SourceCodeEntity parent =
                new SourceCodeEntity("org.foo.bar.Imba", EntityType.CLASS, ChangeModifier.PUBLIC, new SourceRange(
                        0,
                        128));
        Update update = new Update(ChangeType.INCREASING_ACCESSIBILITY_CHANGE, rootEntity, updated, newEntity, parent);
        return update;
    }

    @Override
    protected Map<String, Object[]> addFieldTestValues() {
        return InsertEqualsTest.getFieldTestValues();
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fId"};
    }
}