package org.evolizer.changedistiller.model.test;

import static org.junit.Assert.assertEquals;

import java.util.Date;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.changedistiller.model.entities.Update;
import org.evolizer.core.exceptions.EvolizerException;
import org.evolizer.core.exceptions.EvolizerRuntimeException;
import org.evolizer.model.resources.entities.humans.Person;
import org.evolizer.versioncontrol.cvs.model.entities.ModificationReport;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;
import org.junit.Test;

public class StructureEntityVersionModelTest extends AbstractChangeDistillerModelTest {

    @Test(expected = EvolizerRuntimeException.class)
    public void testSetType() {
        boolean thrown = false;
        for (EntityType value : EntityType.values()) {
            if ((value != EntityType.ATTRIBUTE) && (value != EntityType.CLASS) && (value != EntityType.METHOD)) {
                try {
                    new StructureEntityVersion(value, "foo", ChangeModifier.PUBLIC, new Revision("2.3.1"));
                } catch (EvolizerRuntimeException e) {
                    thrown = true;
                    continue;
                }
                thrown = false;
                break;
            }
        }
        if (thrown) {
            throw new EvolizerRuntimeException();
        }
    }

    @Test
    public void testEquality() throws EvolizerException {
        Revision version = new Revision("1.0.0");
        version.setReport(new ModificationReport(new Date()));
        version.setAuthor(new Person());
        saveToDB(version);

        StructureEntityVersion stEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.Imba", ChangeModifier.PUBLIC, version);
        Delete delete =
                new Delete(ChangeType.REMOVED_FUNCTIONALITY, stEntity, new SourceCodeEntity(
                        "org.foo.Imba.leet()",
                        EntityType.METHOD,
                        new SourceRange(69, 76)), new SourceCodeEntity(
                        "org.foo.Imba",
                        EntityType.CLASS,
                        new SourceRange(0, 576)));
        stEntity.addSourceCodeChange(delete);
        Update update =
                new Update(ChangeType.ATTRIBUTE_RENAMING, stEntity, new SourceCodeEntity(
                        "org.foo.Imba.value : String",
                        EntityType.ATTRIBUTE,
                        new SourceRange(10, 5)), new SourceCodeEntity(
                        "org.foo.Imba.aValue : String",
                        EntityType.ATTRIBUTE,
                        new SourceRange(10, 6)), new SourceCodeEntity(
                        "org.foo.Imba",
                        EntityType.CLASS,
                        new SourceRange(0, 576)));
        stEntity.addSourceCodeChange(update);

        StructureEntityVersion result =
                saveAndUniqueReload(stEntity, "from StructureEntityVersion", StructureEntityVersion.class);

        assertEquals(stEntity, result);
    }
}