package org.evolizer.changedistiller.model.test;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.Insert;
import org.evolizer.changedistiller.model.entities.SourceCodeChange;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class StructureEntityVersionEqualsTest extends AbstractEqualsTest<StructureEntityVersion> {

    @Override
    protected StructureEntityVersion[] createEqualObjects() {
        Revision version = new Revision("1.0.2");
        StructureEntityVersion entity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version);
        SourceCodeEntity parent = new SourceCodeEntity("Imba", EntityType.CLASS, new SourceRange(0, 525));
        Delete delete =
                new Delete(ChangeType.REMOVED_FUNCTIONALITY, entity, new SourceCodeEntity(
                        "do()",
                        EntityType.METHOD,
                        new SourceRange(15, 89)), parent);
        entity.addSourceCodeChange(delete);
        Insert insert =
                new Insert(ChangeType.ADDITIONAL_FUNCTIONALITY, entity, new SourceCodeEntity(
                        "org.foo.bar.Imba.w00t()",
                        EntityType.METHOD,
                        new SourceRange(68, 173)), parent);
        entity.addSourceCodeChange(insert);
        return new StructureEntityVersion[]{entity};
    }

    @Override
    protected StructureEntityVersion createNotEqualObject() {
        Revision version = new Revision("1.0.2");
        StructureEntityVersion entity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Leet", ChangeModifier.PUBLIC, version);
        SourceCodeEntity parent =
                new SourceCodeEntity("org.foo.bar.Imba.doIt()", EntityType.METHOD, new SourceRange(195, 114));
        Delete delete =
                new Delete(ChangeType.REMOVED_OBJECT_STATE, entity, new SourceCodeEntity(
                        "org.foo.bar.Imba.value : String",
                        EntityType.ATTRIBUTE,
                        new SourceRange(22, 8)), parent);
        entity.addSourceCodeChange(delete);
        Insert insert =
                new Insert(ChangeType.STATEMENT_INSERT, entity, new SourceCodeEntity(
                        "foo.bar(obj);",
                        EntityType.METHOD_INVOCATION,
                        new SourceRange(78, 18)), parent);
        entity.addSourceCodeChange(insert);
        return entity;
    }

    @Override
    protected Map<Class<?>, Object[]> addTestValues() {
        Map<Class<?>, Object[]> values = new Hashtable<Class<?>, Object[]>();
        Revision version = new Revision("1.0.0");
        Revision version2 = new Revision("2.0.0");
        values.put(Revision.class, new Object[]{version, version2});
        List<SourceCodeChange> changes = new ArrayList<SourceCodeChange>();
        List<SourceCodeChange> changes2 = new ArrayList<SourceCodeChange>();
        changes.add(new Delete(
                ChangeType.REMOVED_FUNCTIONALITY,
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version),
                new SourceCodeEntity("do()", EntityType.METHOD, new SourceRange(15, 89)),
                new SourceCodeEntity("Imba", EntityType.CLASS, new SourceRange(0, 525))));
        changes2.add(new Insert(
                ChangeType.STATEMENT_INSERT,
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version),
                new SourceCodeEntity("foo.bar(obj);", EntityType.METHOD_INVOCATION, new SourceRange(54, 13)),
                new SourceCodeEntity("org.foo.bar.Imba.doIt()", EntityType.METHOD, new SourceRange(59, 158))));
        values.put(List.class, new Object[]{changes, changes2});
        return values;
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fId", "fSignificanceLevel", "fSourceCodeChanges"};
    }
}