package org.evolizer.changedistiller.model.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.junit.Test;

public class SourceCodeEntityModelTest extends AbstractChangeDistillerModelTest {

    @Test
    public void testEqualityAndAssociatedEntities() throws Exception {
        SourceCodeEntity[] entities = getEntities();

        entities[0].addAssociatedEntity(entities[1]);
        entities[1].addAssociatedEntity(entities[2]);

        List<SourceCodeEntity> results = saveAndReload(entities[0], "from SourceCodeEntity", SourceCodeEntity.class);

        SourceCodeEntity scEntityResult = null;
        SourceCodeEntity scEntityResult2 = null;
        SourceCodeEntity scEntityResult3 = null;
        for (SourceCodeEntity entity : results) {
            if (entity.equals(entities[0])) {
                scEntityResult = entity;
            } else if (entity.equals(entities[1])) {
                scEntityResult2 = entity;
            } else if (entity.equals(entities[2])) {
                scEntityResult3 = entity;
            }
        }
        assertNotNull(scEntityResult);
        results.remove(scEntityResult);
        assertNotNull(scEntityResult2);
        results.remove(scEntityResult2);
        assertNotNull(scEntityResult3);
        results.remove(scEntityResult3);
        assertTrue(results.isEmpty());

        assertEquals(entities[1], scEntityResult.getAssociatedEntities().get(0));
        assertEquals(entities[2], scEntityResult2.getAssociatedEntities().get(0));
    }

    @Test
    public void testCascadeDelete() throws Exception {
        SourceCodeEntity[] entities = getEntities();
        entities[0].addAssociatedEntity(entities[1]);
        List<SourceCodeEntity> results = saveAndReload(entities[0], "from SourceCodeEntity", SourceCodeEntity.class);
        assertTrue(results.size() == 2);
        deleteFromDB(results.get(0));
        assertTrue(reloadFromDB("from SourceCodeEntity", SourceCodeEntity.class).isEmpty());
    }

    private SourceCodeEntity[] getEntities() {
        SourceCodeEntity scEntity =
                new SourceCodeEntity(
                        "org.foo.bar.ChangeDistiller",
                        EntityType.CLASS,
                        ChangeModifier.PUBLIC,
                        new SourceRange(0, 2344));

        SourceCodeEntity scEntity2 =
                new SourceCodeEntity(
                        "org.foo.bar.ChangeDistiller.huga()",
                        EntityType.METHOD,
                        ChangeModifier.PRIVATE,
                        new SourceRange(33, 123));

        SourceCodeEntity scEntity3 =
                new SourceCodeEntity(
                        "org.foo.bar.ChangeDistiller.l33t()",
                        EntityType.METHOD,
                        ChangeModifier.PUBLIC,
                        new SourceRange(145, 199));
        return new SourceCodeEntity[]{scEntity, scEntity2, scEntity3};
    }
}