package org.evolizer.changedistiller.model.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;

public class SourceCodeEntityEqualsTest extends AbstractEqualsTest<SourceCodeEntity> {

    @Override
    protected SourceCodeEntity[] createEqualObjects() {
        SourceCodeEntity scEntity =
                new SourceCodeEntity("org.foo.bar.ChangeDistiller", EntityType.CLASS, new SourceRange(77, 14));
        return new SourceCodeEntity[]{scEntity};
    }

    @Override
    protected SourceCodeEntity createNotEqualObject() {
        return new SourceCodeEntity("org.foo.bar.imba", EntityType.CLASS, 0, new SourceRange(0, 0));
    }

    @Override
    protected Map<Class<?>, Object[]> addTestValues() {
        List<SourceCodeEntity> entities = new ArrayList<SourceCodeEntity>();
        List<SourceCodeEntity> entities2 = new ArrayList<SourceCodeEntity>();
        entities.add(new SourceCodeEntity("org.foo.bar.imba", EntityType.CLASS, 0, new SourceRange(0, 2)));
        entities.add(new SourceCodeEntity("org.foo.bar", EntityType.CLASS, 0, new SourceRange(5, 2)));
        entities2.add(new SourceCodeEntity("org.foo.bar.w000t", EntityType.CLASS, 0, new SourceRange(0, 2)));
        entities2.add(new SourceCodeEntity("org.foo.barfoo", EntityType.CLASS, 0, new SourceRange(5, 2)));
        Map<Class<?>, Object[]> values = new HashMap<Class<?>, Object[]>();
        values.put(List.class, new Object[]{entities, entities2});
        values.put(SourceRange.class, new Object[]{new SourceRange(11, 20), new SourceRange(198, 75)});
        return values;
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fId", "fAssociatedEntities"};
    }
}