package org.evolizer.changedistiller.model.test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.List;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.Insert;
import org.evolizer.changedistiller.model.entities.Move;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.changedistiller.model.entities.Update;
import org.evolizer.core.exceptions.EvolizerException;
import org.evolizer.model.resources.entities.humans.Person;
import org.evolizer.versioncontrol.cvs.model.entities.ModificationReport;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;
import org.junit.Test;

public class SourceCodeChangeModelTest extends AbstractChangeDistillerModelTest {

    @Test
    public void testInsertEquality() throws Exception {
        Insert insert = new Insert(createStructureEntityVersion(), createEntity(), createParentEntity());
        insert.setChangeType(ChangeType.ADDITIONAL_FUNCTIONALITY);

        List<Insert> results = saveAndReload(insert, "from Insert", Insert.class);

        assertEquals(insert, results.get(0));
        assertTrue(insert.hashCode() == results.get(0).hashCode());
    }

    @Test
    public void testMoveEquality() throws Exception {
        Move move =
                new Move(
                        createStructureEntityVersion(),
                        createEntity(),
                        createNewEntity(),
                        createParentEntity(),
                        createParentEntity());
        move.setChangeType(ChangeType.STATEMENT_ORDERING_CHANGE);

        List<Move> results = saveAndReload(move, "from Move", Move.class);

        assertEquals(move, results.get(0));
        assertTrue(move.hashCode() == results.get(0).hashCode());
    }

    @Test
    public void testDeleteEquality() throws EvolizerException {
        Delete delete = new Delete(createStructureEntityVersion(), createEntity(), createParentEntity());
        delete.setChangeType(ChangeType.REMOVED_FUNCTIONALITY);

        List<Delete> results = saveAndReload(delete, "from Delete", Delete.class);

        assertEquals(delete, results.get(0));
        assertTrue(delete.hashCode() == results.get(0).hashCode());
    }

    @Test
    public void testUpdateEquality() throws EvolizerException {
        Update update =
                new Update(createStructureEntityVersion(), createEntity(), createNewEntity(), createParentEntity());
        update.setChangeType(ChangeType.ATTRIBUTE_RENAMING);

        List<Update> results = saveAndReload(update, "from Update", Update.class);

        assertEquals(update, results.get(0));
        assertTrue(update.hashCode() == results.get(0).hashCode());
    }

    private SourceCodeEntity createEntity() {
        return new SourceCodeEntity("org.foo.bar.Imba", EntityType.CLASS, new SourceRange(0, 489));
    }

    private SourceCodeEntity createNewEntity() {
        return new SourceCodeEntity("foo.bar2();", EntityType.METHOD_INVOCATION, new SourceRange(25, 59));
    }

    private SourceCodeEntity createParentEntity() {
        return new SourceCodeEntity("org.foo.bar.Imba.foo()", EntityType.METHOD, new SourceRange(85, 124));
    }

    private StructureEntityVersion createStructureEntityVersion() throws EvolizerException {
        Revision rev = new Revision("1.2");
        ModificationReport modR = new ModificationReport();
        modR.setAuthor(new Person());
        rev.setReport(modR);
        saveToDB(rev);
        StructureEntityVersion stEntityV =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, rev);
        return stEntityV;
    }
}