package org.evolizer.changedistiller.model.test;

import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Move;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class MoveEqualsTest extends AbstractEqualsTest<Move> {

    @Override
    protected Move[] createEqualObjects() {
        Revision version = new Revision("1.0.0");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version);
        SourceCodeEntity moved =
                new SourceCodeEntity("foo.bar();", EntityType.METHOD_INVOCATION, new SourceRange(10, 85));
        SourceCodeEntity newEntity =
                new SourceCodeEntity("foo.bar();", EntityType.METHOD_INVOCATION, new SourceRange(10, 97));
        SourceCodeEntity oldParent =
                new SourceCodeEntity("org.foo.bar.Imba.doIt()", EntityType.METHOD, new SourceRange(77, 89));
        SourceCodeEntity newParent =
                new SourceCodeEntity("org.foo.bar.Imba.doIt()", EntityType.METHOD, new SourceRange(77, 95));
        Move move = new Move(ChangeType.STATEMENT_ORDERING_CHANGE, rootEntity, moved, newEntity, oldParent, newParent);
        return new Move[]{move};
    }

    @Override
    protected Move createNotEqualObject() {
        Revision version = new Revision("1.0.0");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version);
        SourceCodeEntity moved = new SourceCodeEntity("obj != null", EntityType.IF_STATEMENT, new SourceRange(11, 49));
        SourceCodeEntity newEntity =
                new SourceCodeEntity("obj != null", EntityType.IF_STATEMENT, new SourceRange(11, 38));
        SourceCodeEntity oldParent =
                new SourceCodeEntity("org.foo.bar.Imba.leet()", EntityType.METHOD, new SourceRange(30, 128));
        SourceCodeEntity newParent =
                new SourceCodeEntity("org.foo.bar.Imba.leet()", EntityType.METHOD, new SourceRange(77, 95));
        Move move = new Move(ChangeType.STATEMENT_ORDERING_CHANGE, rootEntity, moved, newEntity, oldParent, newParent);
        return move;
    }

    @Override
    protected Map<String, Object[]> addFieldTestValues() {
        return InsertEqualsTest.getFieldTestValues();
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fId"};
    }
}