package org.evolizer.changedistiller.model.test;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.entities.MethodHistory;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class MethodHistoryEqualsTest extends AbstractEqualsTest<MethodHistory> {

    @Override
    protected MethodHistory[] createEqualObjects() {
        MethodHistory history =
                new MethodHistory(new StructureEntityVersion(
                        EntityType.METHOD,
                        "org.foo.Bar.imba()",
                        ChangeModifier.PUBLIC,
                        new Revision("1.0.0")));
        history.addVersion(new StructureEntityVersion(
                EntityType.METHOD,
                "org.foo.Imba.bar()",
                ChangeModifier.PUBLIC,
                new Revision("2.3.0")));
        return new MethodHistory[]{history};
    }

    @Override
    protected MethodHistory createNotEqualObject() {
        MethodHistory history =
                new MethodHistory(new StructureEntityVersion(
                        EntityType.METHOD,
                        "org.leet.Foo.bar()",
                        ChangeModifier.PUBLIC,
                        new Revision("1.1.0")));
        history.addVersion(new StructureEntityVersion(
                EntityType.METHOD,
                "org.foo.Imba.leet()",
                ChangeModifier.PUBLIC,
                new Revision("2.3.0")));
        return history;
    }

    @Override
    protected Map<Class<?>, Object[]> addTestValues() {
        List<StructureEntityVersion> attrVersions = new ArrayList<StructureEntityVersion>();
        List<StructureEntityVersion> attrVersions2 = new ArrayList<StructureEntityVersion>();
        attrVersions.add(new StructureEntityVersion(
                EntityType.METHOD,
                "org.leet.Foo.bar()",
                ChangeModifier.PUBLIC,
                new Revision("1.1.0")));
        attrVersions.add(new StructureEntityVersion(
                EntityType.METHOD,
                "org.foo.Imba.leet()",
                ChangeModifier.PUBLIC,
                new Revision("2.3.0")));
        attrVersions2.add(new StructureEntityVersion(
                EntityType.METHOD,
                "org.Foo.w00t()",
                ChangeModifier.PUBLIC,
                new Revision("1.1.0")));
        attrVersions2.add(new StructureEntityVersion(
                EntityType.METHOD,
                "org.bar.Imba.lol()",
                ChangeModifier.PUBLIC,
                new Revision("2.4.0")));
        Map<Class<?>, Object[]> values = new Hashtable<Class<?>, Object[]>();
        values.put(List.class, new Object[]{attrVersions, attrVersions2});
        return values;
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fNumberOfBodyChanges", "fNumberOfDeclarationChanges", "fSignificanceLevel", "fId"};
    }
}