package org.evolizer.changedistiller.model.test;

import java.util.Hashtable;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Insert;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class InsertEqualsTest extends AbstractEqualsTest<Insert> {

    @Override
    protected Insert[] createEqualObjects() {
        Revision version = new Revision("1.0.0");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version);
        SourceCodeEntity method =
                new SourceCodeEntity("org.foo.bar.Imba.doIt()", EntityType.METHOD, new SourceRange(77, 89));
        SourceCodeEntity parent = new SourceCodeEntity("org.foo.bar.Imba", EntityType.CLASS, new SourceRange(0, 487));
        parent.setType(EntityType.CLASS);
        parent.setSourceRange(new SourceRange(0, 487));
        Insert insert = new Insert(ChangeType.METHOD_RENAMING, rootEntity, method, parent);
        return new Insert[]{insert};
    }

    @Override
    protected Insert createNotEqualObject() {
        Revision version = new Revision("1.0.1");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.METHOD, "org.foo.bar.Leet.foo()", ChangeModifier.PUBLIC, version);
        SourceCodeEntity statement =
                new SourceCodeEntity("org.foo.bar.Leet.foo()", EntityType.IF_STATEMENT, new SourceRange(99, 13));
        SourceCodeEntity parent =
                new SourceCodeEntity("org.foo.bar.Leet.foo()", EntityType.METHOD, new SourceRange(80, 57));
        Insert insert = new Insert(ChangeType.STATEMENT_INSERT, rootEntity, statement, parent);
        return insert;
    }

    @Override
    protected Map<String, Object[]> addFieldTestValues() {
        return getFieldTestValues();
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fId"};
    }

    public static Map<String, Object[]> getFieldTestValues() {
        Revision version = new Revision("1.0.1");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Uber", ChangeModifier.PUBLIC, version);
        StructureEntityVersion rootEntity2 =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.UberLeet", ChangeModifier.PUBLIC, version);
        SourceCodeEntity parentEntity =
                new SourceCodeEntity("org.foo.bar.Uber.foo()", EntityType.METHOD, new SourceRange(10, 20));
        SourceCodeEntity parentEntity2 =
                new SourceCodeEntity("org.foo.bar.UberLeet.foo()", EntityType.METHOD, new SourceRange(10, 29));
        Map<String, Object[]> values = new Hashtable<String, Object[]>();
        values.put("fRootEntity", new Object[]{rootEntity, rootEntity2});
        values.put("fParentEntity", new Object[]{parentEntity, parentEntity2});
        SourceCodeEntity changed =
                new SourceCodeEntity("org.foo.bar.Uber.foo()", EntityType.METHOD, new SourceRange(10, 20));
        SourceCodeEntity changed2 =
                new SourceCodeEntity("org.foo.bar.UberLeet.foo()", EntityType.METHOD, new SourceRange(10, 29));
        values.put("fChangedEntity", new Object[]{changed, changed2});
        values.put("fMovedEntity", new Object[]{changed, changed2});
        values.put("fNewEntity", new Object[]{changed, changed2});
        SourceCodeEntity oldParent =
                new SourceCodeEntity("org.foo.bar.Leet", EntityType.CLASS, new SourceRange(0, 100));
        SourceCodeEntity oldParent2 =
                new SourceCodeEntity("org.foo.bar.Leet.foo()", EntityType.METHOD, new SourceRange(20, 100));
        values.put("fOldParentEntity", new Object[]{oldParent, oldParent2});
        SourceCodeEntity newParent =
                new SourceCodeEntity("org.foo.bar.Leet", EntityType.CLASS, new SourceRange(0, 100));
        SourceCodeEntity newParent2 =
                new SourceCodeEntity("org.foo.bar.Leet.foo()", EntityType.METHOD, new SourceRange(20, 100));
        values.put("fNewParentEntity", new Object[]{newParent, newParent2});
        return values;
    }
}