package org.evolizer.changedistiller.model.test;

import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.ChangeType;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.classifiers.SourceRange;
import org.evolizer.changedistiller.model.entities.Delete;
import org.evolizer.changedistiller.model.entities.SourceCodeEntity;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class DeleteEqualsTest extends AbstractEqualsTest<Delete> {

    @Override
    protected Delete[] createEqualObjects() {
        Revision version = new Revision("1.0.0");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Imba", ChangeModifier.PUBLIC, version);
        SourceCodeEntity method =
                new SourceCodeEntity("org.foo.bar.Imba.doIt()", EntityType.METHOD, new SourceRange(77, 89));
        method.setSourceRange(new SourceRange(77, 89));
        SourceCodeEntity parent = new SourceCodeEntity("org.foo.bar.Imba", EntityType.CLASS, new SourceRange(0, 487));
        Delete delete = new Delete(ChangeType.REMOVED_FUNCTIONALITY, rootEntity, method, parent);
        return new Delete[]{delete};
    }

    @Override
    protected Delete createNotEqualObject() {
        Revision version = new Revision("1.0.1");
        StructureEntityVersion rootEntity =
                new StructureEntityVersion(EntityType.CLASS, "org.foo.bar.Leet", ChangeModifier.PUBLIC, version);
        SourceCodeEntity attribute =
                new SourceCodeEntity("org.foo.bar.Leet.value : String", EntityType.ATTRIBUTE, new SourceRange(27, 13));
        SourceCodeEntity parent = new SourceCodeEntity("org.foo.bar.Leet", EntityType.METHOD, new SourceRange(0, 255));
        Delete delete = new Delete(ChangeType.REMOVED_OBJECT_STATE, rootEntity, attribute, parent);
        return delete;
    }

    @Override
    protected Map<String, Object[]> addFieldTestValues() {
        return InsertEqualsTest.getFieldTestValues();
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fId"};
    }
}