package org.evolizer.changedistiller.model.test;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.entities.ClassHistory;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class ClassHistoryEqualsTest extends AbstractEqualsTest<ClassHistory> {

    @Override
    protected ClassHistory[] createEqualObjects() {
        ClassHistory history =
                new ClassHistory(new StructureEntityVersion(
                        EntityType.CLASS,
                        "org.foo.Bar",
                        ChangeModifier.PUBLIC,
                        new Revision("1.0.0")));
        history.addVersion(new StructureEntityVersion(
                EntityType.CLASS,
                "org.foo.Imba",
                ChangeModifier.PUBLIC,
                new Revision("2.3.0")));
        return new ClassHistory[]{history};
    }

    @Override
    protected ClassHistory createNotEqualObject() {
        ClassHistory history =
                new ClassHistory(new StructureEntityVersion(
                        EntityType.CLASS,
                        "org.leet.Foo",
                        ChangeModifier.PUBLIC,
                        new Revision("1.1.0")));
        history.addVersion(new StructureEntityVersion(
                EntityType.CLASS,
                "org.foo.Imba",
                ChangeModifier.PUBLIC,
                new Revision("2.3.0")));
        return history;
    }

    @Override
    protected Map<Class<?>, Object[]> addTestValues() {
        List<StructureEntityVersion> attrVersions = new ArrayList<StructureEntityVersion>();
        List<StructureEntityVersion> attrVersions2 = new ArrayList<StructureEntityVersion>();
        attrVersions.add(new StructureEntityVersion(
                EntityType.CLASS,
                "org.leet.Foo",
                ChangeModifier.PUBLIC,
                new Revision("1.1.0")));
        attrVersions.add(new StructureEntityVersion(
                EntityType.CLASS,
                "org.foo.Imba",
                ChangeModifier.PUBLIC,
                new Revision("2.3.0")));
        attrVersions2.add(new StructureEntityVersion(EntityType.CLASS, "org.Foo", ChangeModifier.PUBLIC, new Revision(
                "1.1.0")));
        attrVersions2.add(new StructureEntityVersion(
                EntityType.CLASS,
                "org.bar.Imba",
                ChangeModifier.PUBLIC,
                new Revision("2.4.0")));
        Map<Class<?>, Object[]> values = new Hashtable<Class<?>, Object[]>();
        values.put(List.class, new Object[]{attrVersions, attrVersions2});
        return values;
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{
                "fNumberOfBodyChanges",
                "fNumberOfDeclarationChanges",
                "fSignificanceLevel",
                "fId",
                "fMethodHistories",
                "fAttributeHistories",
                "fInnerClassHistories",
                "fIsEmpty"};
    }
}