package org.evolizer.changedistiller.model.test;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.evolizer.changedistiller.model.classifiers.EntityType;
import org.evolizer.changedistiller.model.entities.AttributeHistory;
import org.evolizer.changedistiller.model.entities.StructureEntityVersion;
import org.evolizer.versioncontrol.cvs.model.entities.Revision;

public class AttributeHistoryEqualsTest extends AbstractEqualsTest<AttributeHistory> {

    @Override
    protected AttributeHistory[] createEqualObjects() {
        AttributeHistory history =
                new AttributeHistory(new StructureEntityVersion(
                        EntityType.ATTRIBUTE,
                        "org.foo.Bar.value : String",
                        ChangeModifier.PRIVATE,
                        new Revision("1.0.0")));
        history.addVersion(new StructureEntityVersion(
                EntityType.ATTRIBUTE,
                "org.foo.Bar.leet : String",
                ChangeModifier.PRIVATE,
                new Revision("2.3.0")));
        return new AttributeHistory[]{history};
    }

    @Override
    protected AttributeHistory createNotEqualObject() {
        AttributeHistory history =
                new AttributeHistory(new StructureEntityVersion(
                        EntityType.ATTRIBUTE,
                        "org.leet.Foo.attr : MyClass",
                        ChangeModifier.PRIVATE,
                        new Revision("1.1.0")));
        history.addVersion(new StructureEntityVersion(
                EntityType.ATTRIBUTE,
                "org.leet.Foo.attr: String",
                ChangeModifier.PRIVATE,
                new Revision("2.3.0")));
        return history;
    }

    @Override
    protected Map<Class<?>, Object[]> addTestValues() {
        List<StructureEntityVersion> attrVersions = new ArrayList<StructureEntityVersion>();
        List<StructureEntityVersion> attrVersions2 = new ArrayList<StructureEntityVersion>();
        attrVersions.add(new StructureEntityVersion(
                EntityType.ATTRIBUTE,
                "org.leet.Imba.attr : String",
                ChangeModifier.PRIVATE,
                new Revision("1.1.0")));
        attrVersions.add(new StructureEntityVersion(
                EntityType.ATTRIBUTE,
                "org.leet.Imba.attr : String",
                ChangeModifier.PRIVATE,
                new Revision("2.3.0")));
        attrVersions2.add(new StructureEntityVersion(
                EntityType.ATTRIBUTE,
                "org.foo.Foo.leet : Uber",
                ChangeModifier.PRIVATE,
                new Revision("1.1.0")));
        attrVersions2.add(new StructureEntityVersion(
                EntityType.ATTRIBUTE,
                "org.foo.Foo.leet : Uber",
                ChangeModifier.PRIVATE,
                new Revision("2.4.0")));
        Map<Class<?>, Object[]> values = new Hashtable<Class<?>, Object[]>();
        values.put(List.class, new Object[]{attrVersions, attrVersions2});
        return values;
    }

    @Override
    protected String[] getFieldsToExclude() {
        return new String[]{"fNumberOfBodyChanges", "fNumberOfDeclarationChanges", "fSignificanceLevel", "fId"};
    }
}