package org.evolizer.changedistiller.model.test;

import java.io.InputStream;
import java.util.List;
import java.util.Properties;

import org.evolizer.core.exceptions.EvolizerException;
import org.evolizer.core.hibernate.session.EvolizerSessionHandler;
import org.evolizer.core.hibernate.session.api.IEvolizerSession;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractChangeDistillerModelTest {

	private static final String DB_CONFIG_FILE = "./config/db.properties";
	protected static String fDBUrl;
	protected static String fDBDialect;
	protected static String fDBDriverName;
	protected static String fDBUser;
	protected static String fDBPasswd;
	protected static EvolizerSessionHandler fSessionHandler = null;
	protected static IEvolizerSession fEvoSession = null;

	@BeforeClass
	public static void setUpBeforeClass() throws Exception {
		InputStream propertiesInputStream = Activator.openBundledFile(DB_CONFIG_FILE);

		if (propertiesInputStream != null) {
			Properties props = new Properties();
			props.load(propertiesInputStream);
			propertiesInputStream.close();

			fDBUrl = props.getProperty("dbUrl");
			fDBDialect = props.getProperty("dbDialect");
			fDBDriverName = props.getProperty("dbDriverName");
			fDBUser = props.getProperty("dbUser");
			fDBPasswd = props.getProperty("dbPasswd");
		}
	}

	@Before
	public void setUp() {
		try {
			fSessionHandler = EvolizerSessionHandler.getHandler();
			fSessionHandler.initSessionFactory(fDBUrl, fDBUser, fDBPasswd);
			fSessionHandler.createSchema(fDBUrl, fDBDialect, fDBDriverName, fDBUser, fDBPasswd);
			fEvoSession = fSessionHandler.getCurrentSession(fDBUrl);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	@AfterClass
	public static void tearDownAfterClass() throws Exception {}

	@After
	public void tearDown() throws Exception {
		if (fEvoSession.isOpen()) {
			fEvoSession.flush();
			fEvoSession.close();
		}
		fSessionHandler.dropSchema(fDBUrl, fDBDialect, fDBDriverName, fDBUser, fDBPasswd);
	}

	protected void saveToDB(Object... objects) throws EvolizerException {
		fEvoSession.startTransaction();
		try {
			for (Object o : objects) {
				fEvoSession.saveObject(o);
				// fEvoSession.saveOrUpdate(o);
			}
		} catch (Throwable t) {
			fEvoSession.rollbackTransaction();
			t.printStackTrace();
		} finally {
			fEvoSession.endTransaction();
		}
		fEvoSession.close();
		fEvoSession = fSessionHandler.getCurrentSession(fDBUrl);
	}

	protected <T> T reloadUniqueFromDB(String query, Class<T> resultType) {
		return fEvoSession.uniqueResult(query, resultType);
	}

	protected <T> List<T> reloadFromDB(String query, Class<T> resultType) {
		return fEvoSession.query(query, resultType);
	}

	protected <T> T saveAndUniqueReload(Object object, String query, Class<T> resultType) throws EvolizerException {
		saveToDB(object);
		return reloadUniqueFromDB(query, resultType);
	}

	protected <T> List<T> saveAndReload(Object object, String query, Class<T> resultType) throws EvolizerException {
		saveToDB(object);
		return reloadFromDB(query, resultType);
	}

	protected void deleteFromDB(Object... objects) throws Exception {
		fEvoSession.startTransaction();
		for (Object o : objects) {
			fEvoSession.delete(o);
		}
		fEvoSession.endTransaction();
		fEvoSession.close();
		fEvoSession = fSessionHandler.getCurrentSession(fDBUrl);
	}
}