package org.evolizer.changedistiller.model.classifiers.test;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.evolizer.changedistiller.model.classifiers.ChangeModifier;
import org.junit.Test;

public class ModifierTest {

    @Test
    public void testIsFinal() {
        for (int mod : createNoFinal()) {
            assertFalse(ChangeModifier.isFinal(mod));
        }
        for (int mod : createFinal()) {
            assertTrue(ChangeModifier.isFinal(mod));
        }
    }

    @Test
    public void testIsPublic() {
        for (int mod : createNoPublic()) {
            assertFalse(ChangeModifier.isPublic(mod));
        }
        for (int mod : createPublic()) {
            assertTrue(ChangeModifier.isPublic(mod));
        }
    }

    @Test
    public void testIsPrivate() {
        for (int mod : createNoPrivate()) {
            assertFalse(ChangeModifier.isPrivate(mod));
        }
        for (int mod : createPrivate()) {
            assertTrue(ChangeModifier.isPrivate(mod));
        }
    }

    @Test
    public void testIsProtected() {
        for (int mod : createNoProtected()) {
            assertFalse(ChangeModifier.isProtected(mod));
        }
        for (int mod : createProtected()) {
            assertTrue(ChangeModifier.isProtected(mod));
        }
    }

    private int[] createFinal() {
        int all = ChangeModifier.FINAL | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE | ChangeModifier.PUBLIC;
        int all2 = ChangeModifier.FINAL | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE;
        int finProt = ChangeModifier.FINAL | ChangeModifier.PROTECTED;
        return new int[]{all, all2, finProt, ChangeModifier.FINAL};
    }

    private int[] createProtected() {
        int all = ChangeModifier.FINAL | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE | ChangeModifier.PUBLIC;
        int all2 = ChangeModifier.FINAL | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE;
        int finProt = ChangeModifier.FINAL | ChangeModifier.PROTECTED;
        return new int[]{all, all2, finProt, ChangeModifier.PROTECTED};
    }

    public int[] createPublic() {
        int all = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE | ChangeModifier.FINAL;
        int all2 = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED | ChangeModifier.FINAL;
        int pubPriv = ChangeModifier.PUBLIC | ChangeModifier.PRIVATE;
        return new int[]{all, all2, pubPriv, ChangeModifier.PUBLIC};
    }

    public int[] createPrivate() {
        int all = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE | ChangeModifier.FINAL;
        int all2 = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE;
        int privProt = ChangeModifier.PRIVATE | ChangeModifier.PROTECTED;
        return new int[]{all, all2, privProt, ChangeModifier.PRIVATE};
    }

    private int[] createNoFinal() {
        int all = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE;
        int pubProt = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED;
        int pubPriv = ChangeModifier.PUBLIC | ChangeModifier.PRIVATE;
        int protPriv = ChangeModifier.PRIVATE | ChangeModifier.PROTECTED;
        return new int[]{all, pubProt, pubPriv, protPriv};
    }

    private int[] createNoProtected() {
        int all = ChangeModifier.PUBLIC | ChangeModifier.FINAL | ChangeModifier.PRIVATE;
        int pubFin = ChangeModifier.PUBLIC | ChangeModifier.FINAL;
        int pubPriv = ChangeModifier.PUBLIC | ChangeModifier.PRIVATE;
        int privFin = ChangeModifier.PRIVATE | ChangeModifier.FINAL;
        return new int[]{all, pubFin, pubPriv, privFin};
    }

    private int[] createNoPublic() {
        int all = ChangeModifier.FINAL | ChangeModifier.PROTECTED | ChangeModifier.PRIVATE;
        int finProt = ChangeModifier.FINAL | ChangeModifier.PROTECTED;
        int finPriv = ChangeModifier.FINAL | ChangeModifier.PRIVATE;
        int protPriv = ChangeModifier.PRIVATE | ChangeModifier.PROTECTED;
        return new int[]{all, finProt, finPriv, protPriv};
    }

    private int[] createNoPrivate() {
        int all = ChangeModifier.FINAL | ChangeModifier.PROTECTED | ChangeModifier.PUBLIC;
        int finProt = ChangeModifier.FINAL | ChangeModifier.PROTECTED;
        int finPub = ChangeModifier.FINAL | ChangeModifier.PUBLIC;
        int pubProt = ChangeModifier.PUBLIC | ChangeModifier.PROTECTED;
        return new int[]{all, finProt, finPub, pubProt};
    }

}
