package org.evolizer.changedistiller.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.PropertyConfigurator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.evolizer.core.exceptions.EvolizerRuntimeException;
import org.evolizer.core.logging.base.PluginLogManager;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class ChangeDistillerHibernatePlugin extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.evolizer.changedistiller.hibernate";

	// The shared instance
	private static ChangeDistillerHibernatePlugin plugin;
	
	// The path to the log4j.properties file
	private static final String LOG_PROPERTIES_FILE = "config/log4j.properties";

	// The log manager
	private PluginLogManager fLogManager;

	/**
	 * The constructor
	 */
	public ChangeDistillerHibernatePlugin() {
		plugin = this;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		configure();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	@SuppressWarnings("unqualified-field-access")
	public void stop(BundleContext context) throws Exception {
		plugin = null;

		if (fLogManager != null) {
			fLogManager.shutdown();
			fLogManager = null;
		}
		
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static ChangeDistillerHibernatePlugin getDefault() {
		return plugin;
	}

	/**
     * Opens a file located within the plugin-bundle
     * @param filePath relative path of the file starting 
     * @return an InputStream reading the specifed file
     * @throws IOException if file could not be opened
     */
    public static InputStream openBundledFile(String filePath) throws IOException {
            return ChangeDistillerHibernatePlugin.getDefault()
            .getBundle().getEntry(filePath).openStream();
    }
	
    public static PluginLogManager getLogManager() {
		return getDefault().fLogManager; 
	}

	/**
	 * Configures logging
	 *
	 */
	@SuppressWarnings("unqualified-field-access")
	private void configure() {
		try {
			InputStream propertiesInputStream = openBundledFile(LOG_PROPERTIES_FILE);

			if (propertiesInputStream != null) {
				Properties props = new Properties();
				props.load(propertiesInputStream);
				propertiesInputStream.close();
				
				//Hack: Allows us, to configure hibernate logging independently from other stuff.
				PropertyConfigurator.configure(props);
				
				fLogManager = new PluginLogManager(this, props);
			}
			
			propertiesInputStream.close();
		}

		catch (Exception e) {
			String message = "Error while initializing log properties." + e.getMessage();

			IStatus status = new Status(IStatus.ERROR, getDefault().getBundle().getSymbolicName(), IStatus.ERROR, message, e);
			getLog().log(status);

			throw new EvolizerRuntimeException("Error while initializing log properties.", e);
		}
	}
}
