/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cpd.decorators;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicationDensityDecorator
implements Decorator {
    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(CoreMetrics.NCLOC, CoreMetrics.COMMENT_LINES, CoreMetrics.DUPLICATED_LINES, CoreMetrics.LINES);
    }

    @DependedUpon
    public Metric generatesMetric() {
        return CoreMetrics.DUPLICATED_LINES_DENSITY;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        Measure nbDuplicatedLines = context.getMeasure(CoreMetrics.DUPLICATED_LINES);
        if (nbDuplicatedLines == null) {
            return;
        }
        Double divisor = this.getNbLinesFromLocOrNcloc(context);
        if (divisor != null && divisor > 0.0) {
            context.saveMeasure(CoreMetrics.DUPLICATED_LINES_DENSITY, this.calculate(nbDuplicatedLines.getValue(), divisor));
        }
    }

    private Double getNbLinesFromLocOrNcloc(DecoratorContext context) {
        Measure nbLoc = context.getMeasure(CoreMetrics.LINES);
        if (nbLoc != null) {
            return nbLoc.getValue();
        }
        Measure nbNcloc = context.getMeasure(CoreMetrics.NCLOC);
        if (nbNcloc != null) {
            Measure nbComments = context.getMeasure(CoreMetrics.COMMENT_LINES);
            Double nbLines = nbNcloc.getValue();
            return nbComments != null ? nbLines + nbComments.getValue() : nbLines;
        }
        return null;
    }

    protected Double calculate(Double dividend, Double divisor) {
        Double result = 100.0 * dividend / divisor;
        if (result < 100.0) {
            return result;
        }
        return 100.0;
    }
}

