/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cpd;

import java.io.File;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.cpd.JavaTokenizer;
import net.sourceforge.pmd.cpd.Tokenizer;
import org.sonar.api.batch.CpdMapping;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCpdMapping
implements CpdMapping {
    private String ignore_literals;
    private String ignore_identifiers;

    public JavaCpdMapping(Project project) {
        this.ignore_literals = project.getConfiguration().getString("sonar.cpd.ignore_literals", "true");
        this.ignore_identifiers = project.getConfiguration().getString("sonar.cpd.ignore_identifiers", "false");
    }

    public Tokenizer getTokenizer() {
        Properties props = new Properties();
        props.setProperty("ignore_literals", this.ignore_literals);
        props.setProperty("ignore_identifiers", this.ignore_identifiers);
        JavaTokenizer tokenizer = new JavaTokenizer();
        tokenizer.setProperties(props);
        return tokenizer;
    }

    public Resource createResource(File file, List<File> sourceDirs) {
        return JavaFile.fromIOFile((File)file, sourceDirs, (boolean)false);
    }

    public Language getLanguage() {
        return Java.INSTANCE;
    }
}

