/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cpd;

import java.io.IOException;
import java.nio.charset.Charset;
import net.sourceforge.pmd.cpd.AbstractLanguage;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.TokenEntry;
import org.apache.commons.configuration.Configuration;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.CpdMapping;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.Project;
import org.sonar.duplications.cpd.CPD;
import org.sonar.plugins.cpd.CpdAnalyser;
import org.sonar.plugins.cpd.CpdException;

public class CpdSensor
implements Sensor {
    private CpdMapping[] mappings;

    public CpdSensor(CpdMapping[] mappings) {
        this.mappings = mappings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        CpdMapping mapping = this.getMapping(project.getLanguage());
        if (mapping == null) {
            LoggerFactory.getLogger(this.getClass()).info("Detection of duplication code is not supported for {}.", (Object)project.getLanguage());
            return false;
        }
        if (this.isSkipped(project)) {
            LoggerFactory.getLogger(this.getClass()).info("Detection of duplicated code is skipped");
            return false;
        }
        return true;
    }

    boolean isSkipped(Project project) {
        Configuration conf = project.getConfiguration();
        return conf.getBoolean("sonar.cpd." + project.getLanguageKey() + ".skip", conf.getBoolean("sonar.cpd.skip", false));
    }

    public void analyse(Project project, SensorContext context) {
        CpdMapping mapping = this.getMapping(project.getLanguage());
        CPD cpd = this.executeCPD(project, mapping, project.getFileSystem().getSourceCharset());
        this.saveResults(cpd, mapping, project, context);
    }

    private CpdMapping getMapping(org.sonar.api.resources.Language language) {
        for (CpdMapping cpdMapping : this.mappings) {
            if (!cpdMapping.getLanguage().equals(language)) continue;
            return cpdMapping;
        }
        return null;
    }

    private void saveResults(CPD cpd, CpdMapping mapping, Project project, SensorContext context) {
        CpdAnalyser cpdAnalyser = new CpdAnalyser(project, context, mapping);
        cpdAnalyser.analyse(cpd.getMatches());
    }

    private CPD executeCPD(Project project, CpdMapping mapping, Charset encoding) {
        try {
            CPD cpd = this.configureCPD(project, mapping, encoding);
            cpd.go();
            return cpd;
        }
        catch (Exception e) {
            throw new CpdException(e);
        }
    }

    private CPD configureCPD(Project project, CpdMapping mapping, Charset encoding) throws IOException {
        TokenEntry.clearImages();
        int minTokens = this.getMinimumTokens(project);
        AbstractLanguage cpdLanguage = new AbstractLanguage(mapping.getTokenizer(), new String[0]){};
        CPD cpd = new CPD(minTokens, (Language)cpdLanguage);
        cpd.setEncoding(encoding.name());
        cpd.setLoadSourceCodeSlices(false);
        cpd.add(project.getFileSystem().getSourceFiles(new org.sonar.api.resources.Language[]{project.getLanguage()}));
        return cpd;
    }

    int getMinimumTokens(Project project) {
        Configuration conf = project.getConfiguration();
        return conf.getInt("sonar.cpd." + project.getLanguageKey() + ".minimumTokens", conf.getInt("sonar.cpd.minimumTokens", 100));
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

