/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.cpd;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.cpd.TokenEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.CpdMapping;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.duplications.cpd.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpdAnalyser {
    private static final Logger LOG = LoggerFactory.getLogger(CpdAnalyser.class);
    private CpdMapping mapping;
    private SensorContext context;
    private Project project;

    public CpdAnalyser(Project project, SensorContext context, CpdMapping mapping) {
        this.mapping = mapping;
        this.context = context;
        this.project = project;
    }

    public void analyse(Iterator<Match> matches) {
        HashMap<Resource, DuplicationsData> duplicationsData = new HashMap<Resource, DuplicationsData>();
        while (matches.hasNext()) {
            Match match = matches.next();
            for (TokenEntry firstMark : match.getMarkSet()) {
                String firstAbsolutePath = firstMark.getTokenSrcID();
                int firstLine = firstMark.getBeginLine();
                Resource firstFile = this.mapping.createResource(new File(firstAbsolutePath), this.project.getFileSystem().getSourceDirs());
                if (firstFile == null) {
                    LOG.warn("CPD - File not found : {}", (Object)firstAbsolutePath);
                    continue;
                }
                DuplicationsData firstFileData = this.getDuplicationsData(duplicationsData, firstFile);
                firstFileData.incrementDuplicatedBlock();
                for (TokenEntry tokenEntry : match.getMarkSet()) {
                    String secondAbsolutePath = tokenEntry.getTokenSrcID();
                    int secondLine = tokenEntry.getBeginLine();
                    if (secondAbsolutePath.equals(firstAbsolutePath) && firstLine == secondLine) continue;
                    Resource secondFile = this.mapping.createResource(new File(secondAbsolutePath), this.project.getFileSystem().getSourceDirs());
                    if (secondFile == null) {
                        LOG.warn("CPD - File not found : {}", (Object)secondAbsolutePath);
                        continue;
                    }
                    firstFileData.cumulate(secondFile, secondLine, firstLine, match.getLineCount());
                }
            }
        }
        for (DuplicationsData data : duplicationsData.values()) {
            data.saveUsing(this.context);
        }
    }

    private DuplicationsData getDuplicationsData(Map<Resource, DuplicationsData> fileContainer, Resource file) {
        DuplicationsData data = fileContainer.get(file);
        if (data == null) {
            data = new DuplicationsData(file, this.context);
            fileContainer.put(file, data);
        }
        return data;
    }

    private static final class DuplicationsData {
        protected Set<Integer> duplicatedLines = new HashSet<Integer>();
        protected double duplicatedBlocks = 0.0;
        protected Resource resource;
        private SensorContext context;
        private List<StringBuilder> duplicationXMLEntries = new ArrayList<StringBuilder>();

        private DuplicationsData(Resource resource, SensorContext context) {
            this.context = context;
            this.resource = resource;
        }

        protected void cumulate(Resource targetResource, int targetDuplicationStartLine, int duplicationStartLine, int duplicatedLines) {
            StringBuilder xml = new StringBuilder();
            xml.append("<duplication lines=\"").append(duplicatedLines).append("\" start=\"").append(duplicationStartLine).append("\" target-start=\"").append(targetDuplicationStartLine).append("\" target-resource=\"").append(this.context.saveResource(targetResource)).append("\"/>");
            this.duplicationXMLEntries.add(xml);
            for (int duplicatedLine = duplicationStartLine; duplicatedLine < duplicationStartLine + duplicatedLines; ++duplicatedLine) {
                this.duplicatedLines.add(duplicatedLine);
            }
        }

        protected void incrementDuplicatedBlock() {
            this.duplicatedBlocks += 1.0;
        }

        protected void saveUsing(SensorContext context) {
            context.saveMeasure(this.resource, CoreMetrics.DUPLICATED_FILES, Double.valueOf(1.0));
            context.saveMeasure(this.resource, CoreMetrics.DUPLICATED_LINES, Double.valueOf(this.duplicatedLines.size()));
            context.saveMeasure(this.resource, CoreMetrics.DUPLICATED_BLOCKS, Double.valueOf(this.duplicatedBlocks));
            context.saveMeasure(this.resource, new Measure(CoreMetrics.DUPLICATIONS_DATA, this.getDuplicationXMLData()));
        }

        private String getDuplicationXMLData() {
            StringBuilder duplicationXML = new StringBuilder("<duplications>");
            for (StringBuilder xmlEntry : this.duplicationXMLEntries) {
                duplicationXML.append((CharSequence)xmlEntry);
            }
            duplicationXML.append("</duplications>");
            return duplicationXML.toString();
        }
    }
}

