/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.gui2.BugAspects;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.SortableStringComparator;
import edu.umd.cs.findbugs.util.ClassName;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Sortables implements Comparator<BugAspects.SortableValue>
{
    FIRSTVERSION(L10N.getLocalString("sort.first_version", "First Version")){

        public String getFrom(BugInstance bug) {
            return Long.toString(bug.getFirstVersion());
        }

        public String formatValue(String value) {
            int seqNum = Integer.parseInt(value);
            BugCollection bugCollection = MainFrame.getInstance().bugCollection;
            if (bugCollection == null) {
                return "--";
            }
            AppVersion appVersion = bugCollection.getAppVersionFromSequenceNumber(seqNum);
            String appendItem = "";
            if (appVersion != null) {
                String timestamp = new Timestamp(appVersion.getTimestamp()).toString();
                appendItem = appVersion.getReleaseName() + " (" + timestamp.substring(0, timestamp.indexOf(32)) + ")";
            }
            if (appendItem == "") {
                appendItem = "#" + seqNum;
            }
            return appendItem;
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            return Integer.valueOf(one.value).compareTo(Integer.valueOf(two.value));
        }
    }
    ,
    LASTVERSION(L10N.getLocalString("sort.last_version", "Last Version")){

        public String getFrom(BugInstance bug) {
            return Long.toString(bug.getLastVersion());
        }

        public String formatValue(String value) {
            if (value.equals("-1")) {
                return "";
            }
            int seqNum = Integer.parseInt(value);
            BugCollection bugCollection = MainFrame.getInstance().bugCollection;
            if (bugCollection == null) {
                return "--";
            }
            AppVersion appVersion = bugCollection.getAppVersionFromSequenceNumber(seqNum);
            String appendItem = "";
            if (appVersion != null) {
                String timestamp = new Timestamp(appVersion.getTimestamp()).toString();
                appendItem = appVersion.getReleaseName() + " (" + timestamp.substring(0, timestamp.indexOf(32)) + ")";
            }
            if (appendItem == "") {
                appendItem = "#" + seqNum;
            }
            return appendItem;
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            int second;
            if (one.value.equals(two.value)) {
                return 0;
            }
            int first = Integer.valueOf(one.value);
            if (first == (second = Integer.valueOf(two.value).intValue())) {
                return 0;
            }
            if (first < 0) {
                return 1;
            }
            if (second < 0) {
                return -1;
            }
            if (first < second) {
                return -1;
            }
            return 1;
        }
    }
    ,
    PRIORITY(L10N.getLocalString("sort.priority", "Priority")){

        public String getFrom(BugInstance bug) {
            return String.valueOf(bug.getPriority());
        }

        public String formatValue(String value) {
            if (value.equals(String.valueOf(1))) {
                return L10N.getLocalString("sort.priority_high", "High");
            }
            if (value.equals(String.valueOf(2))) {
                return L10N.getLocalString("sort.priority_normal", "Normal");
            }
            if (value.equals(String.valueOf(3))) {
                return L10N.getLocalString("sort.priority_low", "Low");
            }
            if (value.equals(String.valueOf(4))) {
                return L10N.getLocalString("sort.priority_experimental", "Experimental");
            }
            return L10N.getLocalString("sort.priority_ignore", "Ignore");
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            return Integer.valueOf(one.value).compareTo(Integer.valueOf(two.value));
        }
    }
    ,
    CLASS(L10N.getLocalString("sort.class", "Class")){

        public String getFrom(BugInstance bug) {
            return bug.getPrimarySourceLineAnnotation().getClassName();
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            try {
                if (one.value.contains("$") && two.value.contains("$") && one.value.substring(0, one.value.lastIndexOf("$")).equals(two.value.substring(0, two.value.lastIndexOf("$")))) {
                    return Integer.valueOf(one.value.substring(one.value.lastIndexOf("$"))).compareTo(Integer.valueOf(two.value.substring(two.value.lastIndexOf("$"))));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return one.value.compareTo(two.value);
        }
    }
    ,
    PACKAGE(L10N.getLocalString("sort.package", "Package")){

        public String getFrom(BugInstance bug) {
            return bug.getPrimarySourceLineAnnotation().getPackageName();
        }

        public String formatValue(String value) {
            if (value.equals("")) {
                return "(Default)";
            }
            return value;
        }
    }
    ,
    PACKAGE_PREFIX(L10N.getLocalString("sort.package_prefix", "Package prefix")){

        public String getFrom(BugInstance bug) {
            int count = GUISaveState.getInstance().getPackagePrefixSegments();
            if (count < 1) {
                count = 1;
            }
            String packageName = bug.getPrimarySourceLineAnnotation().getPackageName();
            return ClassName.extractPackagePrefix(packageName, count);
        }

        public String formatValue(String value) {
            return value + "...";
        }
    }
    ,
    CATEGORY(L10N.getLocalString("sort.category", "Category")){

        public String getFrom(BugInstance bug) {
            BugPattern bugPattern = bug.getBugPattern();
            if (bugPattern == null) {
                return "?";
            }
            return bugPattern.getCategory();
        }

        public String formatValue(String value) {
            return I18N.instance().getBugCategoryDescription(value);
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            String catOne = one.value;
            String catTwo = two.value;
            int compare = catOne.compareTo(catTwo);
            if (compare == 0) {
                return 0;
            }
            if (catOne.equals("CORRECTNESS")) {
                return -1;
            }
            if (catTwo.equals("CORRECTNESS")) {
                return 1;
            }
            return compare;
        }
    }
    ,
    DESIGNATION(L10N.getLocalString("sort.designation", "Designation")){

        public String getFrom(BugInstance bug) {
            return bug.getUserDesignationKey();
        }

        public String formatValue(String value) {
            return I18N.instance().getUserDesignation(value);
        }

        public String[] getAllSorted() {
            List<String> sortedDesignations = I18N.instance().getUserDesignationKeys(true);
            return sortedDesignations.toArray(new String[sortedDesignations.size()]);
        }
    }
    ,
    BUGCODE(L10N.getLocalString("sort.bug_kind", "Bug Kind")){

        public String getFrom(BugInstance bug) {
            BugPattern bugPattern = bug.getBugPattern();
            if (bugPattern == null) {
                return null;
            }
            return bugPattern.getAbbrev();
        }

        public String formatValue(String value) {
            return I18N.instance().getBugTypeDescription(value);
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            return this.formatValue(one.value).compareTo(this.formatValue(two.value));
        }
    }
    ,
    TYPE(L10N.getLocalString("sort.bug_pattern", "Bug Pattern")){

        public String getFrom(BugInstance bug) {
            if (bug.getBugPattern() == null) {
                return "?";
            }
            return bug.getBugPattern().getType();
        }

        public String formatValue(String value) {
            return I18N.instance().getShortMessageWithoutCode(value);
        }
    }
    ,
    BUG_RANK(L10N.getLocalString("sort.bug_bugrank", "Bug Rank")){
        String[] values = new String[40];
        {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = String.format("%2d", i);
            }
        }

        public String getFrom(BugInstance bug) {
            if (bug.getBugPattern() == null) {
                return "??";
            }
            int rank = BugRanker.findRank(bug);
            return this.values[rank];
        }

        public String formatValue(String value) {
            return value;
        }
    }
    ,
    PROJECT(L10N.getLocalString("sort.bug_project", "Project")){

        public String getFrom(BugInstance bug) {
            ProjectPackagePrefixes p = MainFrame.getInstance().projectPackagePrefixes;
            TreeSet<String> projects = p.getProjects(bug.getPrimaryClass().getClassName());
            if (projects.size() == 0) {
                return "unclassified";
            }
            String result = ((Object)projects).toString();
            return result.substring(1, result.length() - 1);
        }

        public boolean isAvailable(MainFrame mf) {
            return mf.projectPackagePrefixes.size() > 0;
        }
    }
    ,
    DIVIDER(" "){

        public String getFrom(BugInstance bug) {
            throw new UnsupportedOperationException();
        }

        public String[] getAll() {
            throw new UnsupportedOperationException();
        }

        public String formatValue(String value) {
            throw new UnsupportedOperationException();
        }

        public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
            throw new UnsupportedOperationException();
        }
    };

    String prettyName;
    private SortableStringComparator comparator = new SortableStringComparator(this);

    private Sortables(String prettyName) {
        this.prettyName = prettyName;
    }

    public String toString() {
        return this.prettyName;
    }

    public abstract String getFrom(BugInstance var1);

    public String[] getAll() {
        return this.getAll(BugSet.getMainBugSet());
    }

    public String[] getAll(BugSet set) {
        return set.getAll(this);
    }

    public String formatValue(String value) {
        return value;
    }

    @Override
    public int compare(BugAspects.SortableValue one, BugAspects.SortableValue two) {
        return one.value.compareTo(two.value);
    }

    public String[] getAllSorted() {
        return this.getAllSorted(BugSet.getMainBugSet());
    }

    public String[] getAllSorted(BugSet set) {
        int i;
        String[] values = this.getAll(set);
        BugAspects.SortableValue[] pairs = new BugAspects.SortableValue[values.length];
        for (i = 0; i < values.length; ++i) {
            pairs[i] = new BugAspects.SortableValue(this, values[i]);
        }
        Arrays.sort(pairs, this);
        for (i = 0; i < values.length; ++i) {
            values[i] = pairs[i].value;
        }
        return values;
    }

    public SortableStringComparator getComparator() {
        return this.comparator;
    }

    public Comparator<BugLeafNode> getBugLeafNodeComparator() {
        final Sortables key = this;
        return new Comparator<BugLeafNode>(){

            @Override
            public int compare(BugLeafNode one, BugLeafNode two) {
                return key.compare(new BugAspects.SortableValue(key, key.getFrom(one.getBug())), new BugAspects.SortableValue(key, key.getFrom(two.getBug())));
            }
        };
    }

    public boolean isAvailable(MainFrame frame) {
        return true;
    }

    public static Sortables getSortableByPrettyName(String name) {
        for (Sortables s : Sortables.values()) {
            if (!s.prettyName.equals(name)) continue;
            return s;
        }
        return null;
    }
}

