/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.gui2.AnalysisCallback;
import edu.umd.cs.findbugs.gui2.AnalyzingDialog;
import edu.umd.cs.findbugs.gui2.BugLeafNode;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.FindBugsAnalysisFileFilter;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.workflow.Update;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class BugLoader {
    public static BugCollection doAnalysis(@NonNull Project p, FindBugsProgress progressCallback) throws IOException, InterruptedException {
        BugCollectionBugReporter pcb = new BugCollectionBugReporter(p);
        pcb.setPriorityThreshold(2);
        IFindBugsEngine fb = BugLoader.createEngine(p, pcb);
        fb.setUserPreferences(UserPreferences.getUserPreferences());
        fb.setProgressCallback(progressCallback);
        fb.setProjectName(p.getProjectName());
        fb.execute();
        return pcb.getBugCollection();
    }

    private static IFindBugsEngine createEngine(@NonNull Project p, BugReporter pcb) {
        FindBugs2 engine = new FindBugs2();
        engine.setBugReporter(pcb);
        engine.setProject(p);
        engine.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        engine.setAnalysisFeatureSettings(Driver.getAnalysisSettingList());
        return engine;
    }

    public static BugSet loadBugsHelper(BugCollection collection) {
        ArrayList<BugLeafNode> bugList = new ArrayList<BugLeafNode>();
        Iterator<BugInstance> i = collection.iterator();
        while (i.hasNext()) {
            bugList.add(new BugLeafNode(i.next()));
        }
        return new BugSet(bugList);
    }

    @CheckForNull
    public static SortedBugCollection loadBugs(MainFrame mainFrame, Project project, File source) {
        if (!source.isFile() || !source.canRead()) {
            JOptionPane.showMessageDialog(mainFrame, "Unable to read " + source);
            return null;
        }
        SortedBugCollection col = new SortedBugCollection(project);
        col.setRequestDatabaseCloud(true);
        try {
            col.readXML(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(mainFrame, "Could not read " + source + "; " + e.getMessage());
        }
        BugLoader.addDeadBugMatcher(project);
        return col;
    }

    @CheckForNull
    public static SortedBugCollection loadBugs(MainFrame mainFrame, Project project, URL url) {
        SortedBugCollection col;
        block2: {
            col = new SortedBugCollection(project);
            col.setRequestDatabaseCloud(true);
            try {
                col.readXML(url);
            }
            catch (Exception e) {
                String msg = SystemProperties.getOSDependentProperty("findbugs.unableToLoadViaURL");
                msg = msg == null ? e.getMessage() : String.format(msg, new Object[0]);
                JOptionPane.showMessageDialog(mainFrame, "Could not read " + url + "\n" + msg);
                if (!SystemProperties.getBoolean("findbugs.failIfUnableToLoadViaURL")) break block2;
                System.exit(1);
            }
        }
        BugLoader.addDeadBugMatcher(project);
        return col;
    }

    static void addDeadBugMatcher(Project p) {
        Filter suppressionMatcher = p.getSuppressionFilter();
        if (suppressionMatcher != null) {
            suppressionMatcher.softAdd(LastVersionMatcher.DEAD_BUG_MATCHER);
        }
    }

    @CheckForNull
    public static Project loadProject(MainFrame mainFrame, File f) {
        try {
            Project project = Project.readXML(f);
            Filter suppressionMatcher = project.getSuppressionFilter();
            if (suppressionMatcher != null) {
                suppressionMatcher.softAdd(LastVersionMatcher.DEAD_BUG_MATCHER);
            }
            project.setGuiCallback(mainFrame);
            return project;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(mainFrame, "Could not read " + f + "; " + e.getMessage());
        }
        catch (DocumentException e) {
            JOptionPane.showMessageDialog(mainFrame, "Could not read project from " + f + "; " + e.getMessage());
        }
        catch (SAXException e) {
            JOptionPane.showMessageDialog(mainFrame, "Could not read  project from " + f + "; " + e.getMessage());
        }
        return null;
    }

    private BugLoader() {
        throw new UnsupportedOperationException();
    }

    public static BugCollection combineBugHistories() {
        try {
            FBFileChooser chooser = new FBFileChooser();
            chooser.setFileFilter(new FindBugsAnalysisFileFilter());
            chooser.setMultiSelectionEnabled(true);
            chooser.setDialogTitle(L10N.getLocalString("dlg.choose_xmls_ttl", "Choose All XML's To Combine"));
            if (chooser.showOpenDialog(MainFrame.getInstance()) == 1) {
                return null;
            }
            SortedBugCollection conglomeration = new SortedBugCollection();
            conglomeration.readXML(chooser.getSelectedFiles()[0]);
            Update update = new Update();
            for (int x = 1; x < chooser.getSelectedFiles().length; ++x) {
                File f = chooser.getSelectedFiles()[x];
                SortedBugCollection col = new SortedBugCollection();
                col.readXML(f);
                conglomeration = (SortedBugCollection)update.mergeCollections(conglomeration, col, false, false);
            }
            return conglomeration;
        }
        catch (IOException e) {
            Debug.println(e);
            return null;
        }
        catch (DocumentException e) {
            Debug.println(e);
            return null;
        }
    }

    @CheckForNull
    public static BugCollection doAnalysis(@NonNull Project p) {
        if (p == null) {
            throw new NullPointerException("null project");
        }
        RedoAnalysisCallback ac = new RedoAnalysisCallback();
        new AnalyzingDialog(p, ac, true);
        if (ac.finished) {
            return ac.getBugCollection();
        }
        return null;
    }

    @CheckForNull
    public static BugCollection redoAnalysisKeepComments(@NonNull Project p) {
        if (p == null) {
            throw new NullPointerException("null project");
        }
        BugSet oldSet = BugSet.getMainBugSet();
        BugCollection current = MainFrame.getInstance().bugCollection;
        if (current != null) {
            for (BugLeafNode node : oldSet) {
                BugInstance bug = node.getBug();
                current.add(bug);
            }
        }
        Update update = new Update();
        RedoAnalysisCallback ac = new RedoAnalysisCallback();
        new AnalyzingDialog(p, ac, true);
        if (current == null) {
            return ac.getBugCollection();
        }
        if (ac.finished) {
            return update.mergeCollections(current, ac.getBugCollection(), true, false);
        }
        return null;
    }

    private static class RedoAnalysisCallback
    implements AnalysisCallback {
        BugCollection justAnalyzed;
        volatile boolean finished;

        private RedoAnalysisCallback() {
        }

        BugCollection getBugCollection() {
            return this.justAnalyzed;
        }

        public void analysisFinished(BugCollection b) {
            this.justAnalyzed = b;
            this.finished = true;
        }

        public void analysisInterrupted() {
            this.finished = false;
        }
    }
}

