/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import java.io.File;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

public class DumbMethodInvocations
implements Detector {
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;

    public DumbMethodInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        for (Method method : methodList = classContext.getJavaClass().getMethods()) {
            if (method.getCode() == null) continue;
            try {
                this.analyzeMethod(classContext, method);
                this.bugAccumulator.reportAccumulatedBugs();
            }
            catch (MethodUnprofitableException mue) {
                if (!SystemProperties.getBoolean("unprofitable.debug")) continue;
                this.bugReporter.logError("skipping unprofitable method in " + this.getClass().getName());
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Detector " + this.getClass().getName() + " caught exception", e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        CFG cfg = classContext.getCFG(method);
        ConstantDataflow constantDataflow = classContext.getConstantDataflow(method);
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        MethodGen methodGen = classContext.getMethodGen(method);
        String sourceFile = classContext.getJavaClass().getSourceFileName();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            String v;
            Constant operandValue;
            Location location = i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction iins = (InvokeInstruction)ins;
            ConstantFrame frame = (ConstantFrame)constantDataflow.getFactAtLocation(location);
            if (!frame.isValid()) continue;
            if (iins.getName(cpg).equals("getConnection") && iins.getSignature(cpg).equals("(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;") && iins.getClassName(cpg).equals("java.sql.DriverManager") && (operandValue = (Constant)frame.getTopValue()).isConstantString()) {
                String password = operandValue.getConstantString();
                if (password.length() == 0) {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_EMPTY_DB_PASSWORD", 2).addClassAndMethod(methodGen, sourceFile), classContext, methodGen, sourceFile, location);
                } else {
                    this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_CONSTANT_DB_PASSWORD", 2).addClassAndMethod(methodGen, sourceFile), classContext, methodGen, sourceFile, location);
                }
            }
            if (iins.getName(cpg).equals("substring") && iins.getSignature(cpg).equals("(I)Ljava/lang/String;") && iins.getClassName(cpg).equals("java.lang.String")) {
                int v2;
                operandValue = (Constant)frame.getTopValue();
                if (!operandValue.isConstantInteger() || (v2 = operandValue.getConstantInt()) != 0) continue;
                this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_USELESS_SUBSTRING", 2).addClassAndMethod(methodGen, sourceFile), classContext, methodGen, sourceFile, location);
                continue;
            }
            if (!iins.getName(cpg).equals("<init>") || !iins.getSignature(cpg).equals("(Ljava/lang/String;)V") || !iins.getClassName(cpg).equals("java.io.File") || !(operandValue = (Constant)frame.getTopValue()).isConstantString() || !this.isAbsoluteFileName(v = operandValue.getConstantString()) || v.startsWith("/etc/") || v.startsWith("/dev/")) continue;
            int priority = 2;
            if (v.startsWith("/tmp")) {
                priority = 3;
            } else if (v.indexOf("/home") >= 0) {
                priority = 1;
            }
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DMI_HARDCODED_ABSOLUTE_FILENAME", priority).addClassAndMethod(methodGen, sourceFile).addString(v).describe("FILE_NAME"), classContext, methodGen, sourceFile, location);
        }
    }

    private boolean isAbsoluteFileName(String v) {
        if (v.startsWith("/dev/")) {
            return false;
        }
        if (v.startsWith("/")) {
            return true;
        }
        if (v.startsWith("C:")) {
            return true;
        }
        if (v.startsWith("c:")) {
            return true;
        }
        try {
            File f = new File(v);
            return f.isAbsolute();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void report() {
    }
}

