/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.cloud.db;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.ProjectPackagePrefixes;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StartTime;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.cloud.AbstractCloud;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.internalAnnotations.SlashedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.Multiset;
import edu.umd.cs.findbugs.util.Util;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCloud
extends AbstractCloud {
    static final boolean THROW_EXCEPTION_IF_CANT_CONNECT = false;
    private static final String USER_NAME = "user.name";
    Cloud.Mode mode = Cloud.Mode.COMMUNAL;
    int updatesSentToDatabase;
    Date lastUpdate = new Date();
    Date resync;
    Date attemptedResync;
    int resyncCount;
    Map<String, BugData> instanceMap = new HashMap<String, BugData>();
    Map<Integer, BugData> idMap = new HashMap<Integer, BugData>();
    IdentityHashMap<BugDesignation, Integer> bugDesignationId = new IdentityHashMap();
    static final Pattern FORBIDDEN_PACKAGE_PREFIXES = Pattern.compile(SystemProperties.getProperty("findbugs.forbiddenPackagePrefixes", " none ").replace(',', '|'));
    static final boolean PROMPT_FOR_USER_NAME = SystemProperties.getBoolean("findbugs.db.promptForUserName", false);
    int sessionId = -1;
    final CountDownLatch initialSyncDone = new CountDownLatch(1);
    private static final long LAST_SEEN_UPDATE_WINDOW = TimeUnit.MILLISECONDS.convert(604800L, TimeUnit.SECONDS);
    static boolean invocationRecorded;
    boolean scheduled = false;
    int numSkipped = 0;
    static final int MAX_DB_RANK;
    final String url;
    final String dbUser;
    final String dbPassword;
    final String dbName;
    String findbugsUser;
    @CheckForNull
    Pattern sourceFileLinkPattern;
    String sourceFileLinkFormat;
    String sourceFileLinkFormatWithLine;
    String sourceFileLinkToolTip;
    ProjectPackagePrefixes projectMapping = new ProjectPackagePrefixes();
    Map<String, String> prefixBugComponentMapping = new HashMap<String, String>();
    private final String sqlDriver;
    final LinkedBlockingQueue<Update> queue = new LinkedBlockingQueue();
    volatile boolean shutdown = false;
    volatile boolean startShutdown = false;
    final DatabaseSyncTask runner = new DatabaseSyncTask();
    final Thread runnerThread = new Thread((Runnable)this.runner, "Database synchronization thread");
    final Timer resyncTimer = new Timer("Resync scheduler", true);
    private RuntimeException shutdownException = new RuntimeException("DBCloud shutdown");
    private static final String HAS_SKIPPED_BUG = "has_skipped_bugs";
    public static final String PENDING = "-- pending --";
    public static final String NONE = "none";
    static final String BUG_NOTE;
    static final int MAX_URL_LENGTH = 1999;
    private static final String HAS_FILED_BUGS = "has_filed_bugs";
    private static final String HAS_CLASSIFIED_ISSUES = "has_classified_issues";
    private boolean firstBugRequest = true;
    static final String POSTMORTEM_NOTE;
    static final int POSTMORTEM_RANK;
    static final String BUG_LINK_FORMAT;
    static final String BUG_LOGIN_LINK;
    static final String BUG_LOGIN_MSG;
    static final String COMPONENT_FOR_BAD_ANALYSIS;
    String errorMsg;
    long errorTime = 0L;
    static final String LEADERBOARD_BLACKLIST;
    static final Pattern LEADERBOARD_BLACKLIST_PATTERN;

    @Override
    public Cloud.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(Cloud.Mode mode) {
        this.mode = mode;
    }

    BugData getBugData(String instanceHash) {
        BugData bd = this.instanceMap.get(instanceHash);
        if (bd == null) {
            bd = new BugData(instanceHash);
            this.instanceMap.put(instanceHash, bd);
        }
        return bd;
    }

    BugData getBugData(BugInstance bug) {
        try {
            this.initialSyncDone.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        BugData bugData = this.getBugData(bug.getInstanceHash());
        bugData.bugs.add(bug);
        return bugData;
    }

    void loadDatabaseInfo(String hash, int id, long firstSeen, long lastSeen) {
        BugData bd = this.instanceMap.get(hash);
        if (bd == null) {
            return;
        }
        if (this.idMap.containsKey(id)) {
            assert (bd == this.idMap.get(id));
            assert (bd.id == id);
            assert (bd.firstSeen == firstSeen);
        } else {
            bd.id = id;
            bd.firstSeen = firstSeen;
            bd.lastSeen = lastSeen;
            bd.inDatabase = true;
            this.idMap.put(id, bd);
        }
    }

    public DBCloud(BugCollection bugs) {
        super(bugs);
        this.sqlDriver = this.getProperty("dbDriver");
        this.url = this.getProperty("dbUrl");
        this.dbName = this.getProperty("dbName");
        this.dbUser = this.getProperty("dbUser");
        this.dbPassword = this.getProperty("dbPassword");
        this.findbugsUser = this.getProperty("findbugsUser");
    }

    @Override
    public boolean availableForInitialization() {
        return this.sqlDriver != null && this.dbUser != null && this.url != null && this.dbPassword != null;
    }

    @Override
    public void bugsPopulated() {
        this.queue.add(new PopulateBugs(true));
    }

    long boundDuration(long milliseconds) {
        if (milliseconds < 0L) {
            return 0L;
        }
        if (milliseconds > 1000000L) {
            return 1000000L;
        }
        return milliseconds;
    }

    private static String limitToMaxLength(String s, int maxLength) {
        if (s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    private String getProperty(String propertyName) {
        return SystemProperties.getProperty("findbugs.jdbc." + propertyName);
    }

    Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.dbUser, this.dbPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean initialize() {
        boolean bl;
        Connection c;
        block19: {
            if (!this.availableForInitialization()) {
                return false;
            }
            String mode = this.getProperty("votingmode");
            if (mode != null) {
                this.setMode(Cloud.Mode.valueOf(mode.toUpperCase()));
            }
            String sp = SystemProperties.getProperty("findbugs.sourcelink.pattern");
            String sf = SystemProperties.getProperty("findbugs.sourcelink.format");
            String sfwl = SystemProperties.getProperty("findbugs.sourcelink.formatWithLine");
            String stt = SystemProperties.getProperty("findbugs.sourcelink.tooltip");
            if (sp != null && sf != null) {
                try {
                    this.sourceFileLinkPattern = Pattern.compile(sp);
                    this.sourceFileLinkFormat = sf;
                    this.sourceFileLinkToolTip = stt;
                    this.sourceFileLinkFormatWithLine = sfwl;
                }
                catch (RuntimeException e) {
                    AnalysisContext.logError("Could not compile pattern " + sp, e);
                }
            }
            if (this.findbugsUser == null) {
                if (PROMPT_FOR_USER_NAME) {
                    Preferences prefs = Preferences.userNodeForPackage(DBCloud.class);
                    this.findbugsUser = prefs.get(USER_NAME, null);
                    this.findbugsUser = this.bugCollection.getProject().getGuiCallback().showQuestionDialog("Name/handle/email for recording your evaluations?\n(sorry, no authentication or confidentiality currently provided)", "Name for recording your evaluations", this.findbugsUser == null ? "" : this.findbugsUser);
                    if (this.findbugsUser != null) {
                        prefs.put(USER_NAME, this.findbugsUser);
                    }
                } else if (this.findbugsUser == null) {
                    this.findbugsUser = System.getProperty(USER_NAME, "");
                }
                if (this.findbugsUser == null) {
                    return false;
                }
            }
            this.loadBugComponents();
            c = null;
            Class.forName(this.sqlDriver);
            c = this.getConnection();
            Statement stmt = c.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(*) from  findbugs_issue");
            boolean result = false;
            if (rs.next()) {
                result = true;
            }
            rs.close();
            stmt.close();
            c.close();
            if (!result) break block19;
            this.runnerThread.setDaemon(true);
            this.runnerThread.start();
            boolean bl2 = true;
            Util.closeSilently(c);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (RuntimeException e) {
            this.displayMessage("Unable to connect to " + this.dbName, e);
            boolean bl3 = false;
            Util.closeSilently(c);
            return bl3;
        }
        catch (Exception e2) {
            this.displayMessage("Unable to connect to " + this.dbName, e2);
            boolean bl4 = false;
            {
                catch (Throwable throwable) {
                    Util.closeSilently(c);
                    throw throwable;
                }
            }
            Util.closeSilently(c);
            return bl4;
        }
        Util.closeSilently(c);
        return bl;
    }

    private String getBugComponent(@SlashedClassName String className) {
        int longestMatch = -1;
        String result = null;
        for (Map.Entry<String, String> e : this.prefixBugComponentMapping.entrySet()) {
            String key = e.getKey();
            if (!className.startsWith(key) || longestMatch >= key.length()) continue;
            longestMatch = key.length();
            result = e.getValue();
        }
        return result;
    }

    private void loadBugComponents() {
        try {
            URL u = PluginLoader.getCoreResource("bugComponents.properties");
            if (u != null) {
                String s;
                BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
                while ((s = in.readLine()) != null) {
                    if (s.trim().length() == 0) continue;
                    int x = s.indexOf(32);
                    if (x == -1) {
                        if (this.prefixBugComponentMapping.containsKey("")) continue;
                        this.prefixBugComponentMapping.put("", s);
                        continue;
                    }
                    String prefix = s.substring(x + 1);
                    if (this.prefixBugComponentMapping.containsKey(prefix)) continue;
                    this.prefixBugComponentMapping.put(prefix, s.substring(0, x));
                }
                in.close();
            }
        }
        catch (IOException e) {
            AnalysisContext.logError("Unable to load bug component properties", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        block13: {
            try {
                this.startShutdown = true;
                this.resyncTimer.cancel();
                this.queue.add(new ShutdownTask());
                Connection c = null;
                try {
                    c = this.getConnection();
                    PreparedStatement setEndTime = c.prepareStatement("UPDATE  findbugs_invocation SET endTime = ? WHERE id = ?");
                    Timestamp date = new Timestamp(System.currentTimeMillis());
                    int col = 1;
                    setEndTime.setTimestamp(col++, date);
                    setEndTime.setInt(col++, this.sessionId);
                    setEndTime.execute();
                    setEndTime.close();
                }
                catch (Throwable e) {
                }
                finally {
                    Util.closeSilently(c);
                }
                if (this.queue.isEmpty() || !this.runnerThread.isAlive()) break block13;
                this.setErrorMsg("waiting for synchronization to complete before shutdown");
                for (int i = 0; i < 100 && !this.queue.isEmpty(); ++i) {
                    if (!this.runnerThread.isAlive()) {
                        break;
                    }
                    try {
                        Thread.sleep(30L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            finally {
                this.shutdown = true;
                this.runnerThread.interrupt();
            }
        }
    }

    private void checkForShutdown() {
        if (!this.shutdown) {
            return;
        }
        IllegalStateException e = new IllegalStateException("DBCloud has already been shutdown");
        e.initCause(this.shutdownException);
        throw e;
    }

    public void storeNewBug(BugInstance bug, long analysisTime) {
        this.checkForShutdown();
        this.queue.add(new StoreNewBug(bug, analysisTime));
    }

    public void storeFirstSeen(final BugData bd) {
        this.checkForShutdown();
        this.queue.add(new Update(){

            public void execute(DatabaseSyncTask t) throws SQLException {
                t.storeFirstSeen(bd);
            }
        });
    }

    public void storeLastSeen(final BugData bd, final long timestamp) {
        this.checkForShutdown();
        this.queue.add(new Update(){

            public void execute(DatabaseSyncTask t) throws SQLException {
                t.storeLastSeen(bd, timestamp);
            }
        });
    }

    public void storeUserAnnotation(BugData data, BugDesignation bd) {
        this.checkForShutdown();
        this.queue.add(new StoreUserAnnotation(data, bd));
        this.updatedStatus();
        if (DBCloud.firstTimeDoing(HAS_CLASSIFIED_ISSUES)) {
            String msg = "Classification and comments have been sent to database.\nYou'll only see this message the first time your classifcations/comments are sent\nto the database.";
            if (this.mode == Cloud.Mode.VOTING) {
                msg = msg + "\nOnce you've classified an issue, you can see how others have classified it.";
            }
            msg = msg + "\nYour classification and comments are independent from filing a bug using an external\nbug reporting system.";
            this.bugCollection.getProject().getGuiCallback().showMessageDialog(msg);
        }
    }

    private boolean skipBug(BugInstance bug) {
        boolean result;
        boolean bl = result = bug.getBugPattern().getCategory().equals("NOISE") || bug.isDead() || BugRanker.findRank(bug) > MAX_DB_RANK;
        if (result && DBCloud.firstTimeDoing(HAS_SKIPPED_BUG)) {
            this.bugCollection.getProject().getGuiCallback().showMessageDialog("To limit database load, some issues are not persisted to database.\nFor example, issues with rank greater than " + MAX_DB_RANK + " are not stored in the db.\n" + "One of more of the issues you are reviewing will not be persisted,\n" + "and you will not be able to record an evalution of those issues.\n" + "As we scale up the database, we hope to relax these restrictions");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPendingRecord(Connection c, BugData bug, long when, String who) throws SQLException {
        int pendingId = -1;
        PreparedStatement query = null;
        ResultSet rs = null;
        boolean needsUpdate = false;
        try {
            query = c.prepareStatement("SELECT  id, bugReportId, whoFiled, whenFiled FROM findbugs_bugreport where hash=?");
            query.setString(1, bug.instanceHash);
            rs = query.executeQuery();
            while (rs.next()) {
                int col = 1;
                int id = rs.getInt(col++);
                String bugReportId = rs.getString(col++);
                String whoFiled = rs.getString(col++);
                Timestamp whenFiled = rs.getTimestamp(col++);
                if (!bugReportId.equals(PENDING) || !who.equals(whoFiled) && !this.pendingStatusHasExpired(whenFiled.getTime())) {
                    rs.close();
                    query.close();
                    throw new IllegalArgumentException(whoFiled + " already filed bug report " + bugReportId + " for " + bug.instanceHash);
                }
                pendingId = id;
                needsUpdate = !who.equals(whoFiled);
            }
        }
        catch (SQLException e) {
            String msg = "Problem inserting pending record for " + bug.instanceHash;
            AnalysisContext.logError(msg, e);
            return;
        }
        finally {
            rs.close();
            query.close();
        }
        if (pendingId == -1) {
            PreparedStatement insert = c.prepareStatement("INSERT INTO findbugs_bugreport (hash, bugReportId, whoFiled, whenFiled) VALUES (?, ?, ?, ?)");
            Timestamp date = new Timestamp(when);
            int col = 1;
            insert.setString(col++, bug.instanceHash);
            insert.setString(col++, PENDING);
            insert.setString(col++, who);
            insert.setTimestamp(col++, date);
            insert.executeUpdate();
            insert.close();
        } else if (needsUpdate) {
            PreparedStatement updateBug = c.prepareStatement("UPDATE  findbugs_bugreport SET whoFiled = ?,  whenFiled = ? WHERE id = ?");
            try {
                int col = 1;
                updateBug.setString(col++, bug.filedBy);
                updateBug.setTimestamp(col++, new Timestamp(bug.bugFiled));
                updateBug.setInt(col++, pendingId);
                updateBug.executeUpdate();
            }
            catch (SQLException e) {
                String msg = "Problem inserting pending record for id " + pendingId + ", bug hash " + bug.instanceHash;
                AnalysisContext.logError(msg, e);
            }
            finally {
                updateBug.close();
            }
        }
    }

    boolean bugAlreadyFiled(BugInstance b) {
        BugData bd = this.getBugData(b.getInstanceHash());
        if (bd == null || !bd.inDatabase) {
            throw new IllegalArgumentException();
        }
        return bd.bugLink != null && !bd.bugLink.equals(NONE) && !bd.bugLink.equals(PENDING);
    }

    private void displayMessage(String msg, Exception e) {
        AnalysisContext.logError(msg, e);
        if (this.bugCollection != null && this.bugCollection.getProject().isGuiAvaliable()) {
            StringWriter stackTraceWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stackTraceWriter);
            e.printStackTrace(printWriter);
            this.bugCollection.getProject().getGuiCallback().showMessageDialog(String.format("%s - %s\n%s", msg, e.getMessage(), stackTraceWriter.toString()));
        } else {
            System.err.println(msg);
            e.printStackTrace(System.err);
        }
    }

    private void displayMessage(String msg) {
        if (!GraphicsEnvironment.isHeadless() && this.bugCollection.getProject().isGuiAvaliable()) {
            this.bugCollection.getProject().getGuiCallback().showMessageDialog(msg);
        } else {
            System.err.println(msg);
        }
    }

    @Override
    public String getUser() {
        return this.findbugsUser;
    }

    @Override
    public long getFirstSeen(BugInstance b) {
        return this.getBugData((BugInstance)b).firstSeen;
    }

    @Override
    public boolean overallClassificationIsNotAProblem(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return false;
        }
        int isAProblem = 0;
        int notAProblem = 0;
        for (BugDesignation d : bd.getUniqueDesignations()) {
            switch (Cloud.UserDesignation.valueOf(d.getDesignationKey())) {
                case I_WILL_FIX: 
                case MUST_FIX: 
                case SHOULD_FIX: {
                    ++isAProblem;
                    break;
                }
                case BAD_ANALYSIS: 
                case NOT_A_BUG: 
                case MOSTLY_HARMLESS: 
                case OBSOLETE_CODE: {
                    ++notAProblem;
                }
            }
        }
        return notAProblem > isAProblem;
    }

    @Override
    public Cloud.UserDesignation getUserDesignation(BugInstance b) {
        BugDesignation bd = this.getBugData(b).getPrimaryDesignation();
        if (bd == null) {
            return Cloud.UserDesignation.UNCLASSIFIED;
        }
        return Cloud.UserDesignation.valueOf(bd.getDesignationKey());
    }

    @Override
    public String getUserEvaluation(BugInstance b) {
        BugDesignation bd = this.getBugData(b).getPrimaryDesignation();
        if (bd == null) {
            return "";
        }
        String result = bd.getAnnotationText();
        if (result == null) {
            return "";
        }
        return result;
    }

    @Override
    public long getUserTimestamp(BugInstance b) {
        BugDesignation bd = this.getBugData(b).getPrimaryDesignation();
        if (bd == null) {
            return Long.MAX_VALUE;
        }
        return bd.getTimestamp();
    }

    @Override
    public void setUserDesignation(BugInstance b, Cloud.UserDesignation u, long timestamp) {
        BugData data = this.getBugData(b);
        BugDesignation bd = data.getUserDesignation();
        if (bd == null) {
            if (u == Cloud.UserDesignation.UNCLASSIFIED) {
                return;
            }
            bd = data.getNonnullUserDesignation();
        }
        bd.setDesignationKey(u.name());
        if (bd.isDirty()) {
            bd.setTimestamp(timestamp);
            this.storeUserAnnotation(data, bd);
        }
    }

    @Override
    public void setUserEvaluation(BugInstance b, String e, long timestamp) {
        BugData data = this.getBugData(b);
        BugDesignation bd = data.getUserDesignation();
        if (bd == null) {
            if (e.length() == 0) {
                return;
            }
            bd = data.getNonnullUserDesignation();
        }
        bd.setAnnotationText(e);
        if (bd.isDirty()) {
            bd.setTimestamp(timestamp);
            this.storeUserAnnotation(data, bd);
        }
    }

    @Override
    public void setUserTimestamp(BugInstance b, long timestamp) {
        BugData data = this.getBugData(b);
        if (data == null) {
            return;
        }
        BugDesignation bd = data.getNonnullUserDesignation();
        bd.setTimestamp(timestamp);
        this.storeUserAnnotation(data, bd);
    }

    String getBugReportHead(BugInstance b) {
        TreeSet<String> treeSet;
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.println("Bug report generated from FindBugs");
        out.println(b.getMessageWithoutPrefix());
        out.println();
        ClassAnnotation primaryClass = b.getPrimaryClass();
        for (BugAnnotation bugAnnotation : b.getAnnotations()) {
            if (bugAnnotation == primaryClass) {
                out.println(bugAnnotation);
                continue;
            }
            out.println("  " + bugAnnotation.toString(primaryClass));
        }
        URL link = this.getSourceLink(b);
        if (link != null) {
            out.println();
            out.println(this.sourceFileLinkToolTip + ": " + link);
            out.println();
        }
        if (BUG_NOTE != null) {
            out.println(BUG_NOTE);
            if (POSTMORTEM_NOTE != null && BugRanker.findRank(b) <= POSTMORTEM_RANK && !this.overallClassificationIsNotAProblem(b)) {
                out.println(POSTMORTEM_NOTE);
            }
            out.println();
        }
        if ((treeSet = this.projectMapping.getProjects(primaryClass.getClassName())) != null && !treeSet.isEmpty()) {
            String projectList = ((Object)treeSet).toString();
            projectList = projectList.substring(1, projectList.length() - 1);
            out.println("Possibly part of: " + projectList);
            out.println();
        }
        out.close();
        return stringWriter.toString();
    }

    String getBugPatternExplanation(BugInstance b) {
        String detailPlainText = b.getBugPattern().getDetailPlainText();
        return "Bug pattern explanation:\n" + detailPlainText + "\n\n";
    }

    String getBugPatternExplanationLink(BugInstance b) {
        return "Bug pattern explanation: http://findbugs.sourceforge.net/bugDescriptions.html#" + b.getBugPattern().getType() + "\n";
    }

    private String getLineTerminatedUserEvaluation(BugInstance b) {
        Cloud.UserDesignation designation = this.getUserDesignation(b);
        String result = designation != Cloud.UserDesignation.UNCLASSIFIED ? "Classified as: " + designation.toString() + "\n" : "";
        String eval = this.getUserEvaluation(b).trim();
        if (eval.length() > 0) {
            result = result + eval + "\n";
        }
        return result;
    }

    String getBugReport(BugInstance b) {
        return this.getBugReportHead(b) + this.getBugReportSourceCode(b) + this.getLineTerminatedUserEvaluation(b) + this.getBugPatternExplanation(b) + this.getBugReportTail(b);
    }

    String getBugReportShorter(BugInstance b) {
        return this.getBugReportHead(b) + this.getBugReportSourceCode(b) + this.getLineTerminatedUserEvaluation(b) + this.getBugPatternExplanationLink(b) + this.getBugReportTail(b);
    }

    String getBugReportAbridged(BugInstance b) {
        return this.getBugReportHead(b) + this.getBugPatternExplanationLink(b) + this.getBugReportTail(b);
    }

    String getBugReportSourceCode(BugInstance b) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        ClassAnnotation primaryClass = b.getPrimaryClass();
        int firstLine = Integer.MAX_VALUE;
        int lastLine = Integer.MIN_VALUE;
        for (BugAnnotation bugAnnotation : b.getAnnotations()) {
            SourceLineAnnotation s;
            if (!(bugAnnotation instanceof SourceLineAnnotation) || !(s = (SourceLineAnnotation)bugAnnotation).getClassName().equals(primaryClass.getClassName()) || s.getStartLine() <= 0) continue;
            firstLine = Math.min(firstLine, s.getStartLine());
            lastLine = Math.max(lastLine, s.getEndLine());
        }
        SourceLineAnnotation primarySource = primaryClass.getSourceLines();
        if (primarySource.isSourceFileKnown() && firstLine >= 1 && firstLine <= lastLine && lastLine - firstLine < 50) {
            try {
                String txt;
                SourceFile sourceFile = this.getBugCollection().getProject().getSourceFinder().findSourceFile(primarySource);
                BufferedReader in = new BufferedReader(new InputStreamReader(sourceFile.getInputStream()));
                String commonWhiteSpace = null;
                ArrayList<SourceLine> source = new ArrayList<SourceLine>();
                for (int lineNumber = 1; lineNumber <= lastLine + 4 && (txt = in.readLine()) != null; ++lineNumber) {
                    if (lineNumber < firstLine - 4) continue;
                    String trimmed = txt.trim();
                    if (trimmed.length() == 0) {
                        if (lineNumber > lastLine) break;
                        txt = trimmed;
                    }
                    source.add(new SourceLine(lineNumber, txt));
                    commonWhiteSpace = this.commonLeadingWhitespace(commonWhiteSpace, txt);
                }
                in.close();
                out.println("\nRelevant source code:");
                for (SourceLine s : source) {
                    if (s.text.length() == 0) {
                        out.printf("%5d: \n", s.line);
                        continue;
                    }
                    out.printf("%5d:   %s\n", s.line, s.text.substring(commonWhiteSpace.length()));
                }
                out.println();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            out.close();
            String string = stringWriter.toString();
            return string;
        }
        return "";
    }

    String commonLeadingWhitespace(String soFar, String txt) {
        if (txt.length() == 0) {
            return soFar;
        }
        if (soFar == null) {
            return txt;
        }
        soFar = Util.commonPrefix(soFar, txt);
        for (int i = 0; i < soFar.length(); ++i) {
            if (Character.isWhitespace(soFar.charAt(i))) continue;
            return soFar.substring(0, i);
        }
        return soFar;
    }

    String getBugReportTail(BugInstance b) {
        return "\nFindBugs issue identifier (do not modify or remove): " + b.getInstanceHash();
    }

    static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            assert (false);
            return "No utf-8 encoding";
        }
    }

    @Override
    public int getNumberReviewers(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        return uniqueDesignations.size();
    }

    @Override
    public double getClassificationScore(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        double total = 0.0;
        int count = 0;
        for (BugDesignation d : uniqueDesignations) {
            Cloud.UserDesignation designation = Cloud.UserDesignation.valueOf(d.getDesignationKey());
            if (this.nonVoting(designation)) continue;
            total += (double)designation.score();
            ++count;
        }
        return total / (double)count++;
    }

    private boolean nonVoting(Cloud.UserDesignation designation) {
        return designation == Cloud.UserDesignation.OBSOLETE_CODE || designation == Cloud.UserDesignation.NEEDS_STUDY || designation == Cloud.UserDesignation.UNCLASSIFIED;
    }

    @Override
    public double getPortionObsoleteClassifications(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        int count = 0;
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        for (BugDesignation d : uniqueDesignations) {
            if (Cloud.UserDesignation.valueOf(d.getDesignationKey()) != Cloud.UserDesignation.OBSOLETE_CODE) continue;
            ++count;
        }
        return (double)count / (double)uniqueDesignations.size();
    }

    @Override
    public double getClassificationVariance(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        double total = 0.0;
        double totalSquares = 0.0;
        int count = 0;
        for (BugDesignation d : uniqueDesignations) {
            Cloud.UserDesignation designation = Cloud.UserDesignation.valueOf(d.getDesignationKey());
            if (this.nonVoting(designation)) continue;
            int score = designation.score();
            total += (double)score;
            totalSquares += (double)(score * score);
            ++count;
        }
        double average = total / (double)count;
        return totalSquares / (double)count - average * average;
    }

    @Override
    public double getClassificationDisagreement(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return 0.0;
        }
        Collection<BugDesignation> uniqueDesignations = bd.getUniqueDesignations();
        int shouldFix = 0;
        int dontFix = 0;
        for (BugDesignation d : uniqueDesignations) {
            Cloud.UserDesignation designation = Cloud.UserDesignation.valueOf(d.getDesignationKey());
            if (this.nonVoting(designation)) continue;
            int score = designation.score();
            if (score > 0) {
                ++shouldFix;
                continue;
            }
            ++dontFix;
        }
        return (double)Math.min(shouldFix, dontFix) / (double)(shouldFix + dontFix);
    }

    public Set<String> getReviewers(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return Collections.emptySet();
        }
        return bd.getReviewers();
    }

    public boolean isClaimed(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return false;
        }
        return bd.isClaimed();
    }

    private static boolean firstTimeDoing(String activity) {
        Preferences prefs = Preferences.userNodeForPackage(DBCloud.class);
        if (!prefs.getBoolean(activity, false)) {
            prefs.putBoolean(activity, true);
            return true;
        }
        return false;
    }

    private static void alreadyDone(String activity) {
        Preferences prefs = Preferences.userNodeForPackage(DBCloud.class);
        prefs.putBoolean(activity, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public URL getBugLink(BugInstance b) {
        BugData bd = this.getBugData(b);
        String bugNumber = bd.bugLink;
        Cloud.BugFilingStatus status = this.getBugLinkStatus(b);
        if (status == Cloud.BugFilingStatus.VIEW_BUG) {
            return this.getBugViewLink(bugNumber);
        }
        Connection c = null;
        try {
            URL uRL;
            c = this.getConnection();
            PreparedStatement ps = c.prepareStatement("SELECT bugReportId, whoFiled, whenFiled, status, assignedTo, componentName FROM findbugs_bugreport WHERE hash=?");
            ps.setString(1, b.getInstanceHash());
            ResultSet rs = ps.executeQuery();
            Timestamp pendingFiledAt = null;
            while (rs.next()) {
                int col = 1;
                String bugReportId = rs.getString(col++);
                String whoFiled = rs.getString(col++);
                Timestamp whenFiled = rs.getTimestamp(col++);
                String statusString = rs.getString(col++);
                String assignedTo = rs.getString(col++);
                String componentName = rs.getString(col++);
                if (bugReportId.equals(PENDING)) {
                    if (this.findbugsUser.equals(whoFiled) || this.pendingStatusHasExpired(whenFiled.getTime())) continue;
                    pendingFiledAt = whenFiled;
                    continue;
                }
                if (bugReportId.equals(NONE)) continue;
                rs.close();
                ps.close();
                bd.bugLink = bugReportId;
                bd.filedBy = whoFiled;
                bd.bugFiled = whenFiled.getTime();
                bd.bugAssignedTo = assignedTo;
                bd.bugStatus = statusString;
                bd.bugComponentName = componentName;
                int answer = this.getBugCollection().getProject().getGuiCallback().showConfirmDialog("Sorry, but since the time we last received updates from the database,\nsomeone else already filed a bug report. Would you like to view the bug report?", "Someone else already filed a bug report", 0);
                if (answer == 1) {
                    URL uRL2 = null;
                    return uRL2;
                }
                URL uRL3 = this.getBugViewLink(bugReportId);
                return uRL3;
            }
            rs.close();
            ps.close();
            if (pendingFiledAt != null) {
                bd.bugLink = PENDING;
                bd.bugFiled = pendingFiledAt.getTime();
                this.getBugCollection().getProject().getGuiCallback().showMessageDialog("Sorry, but since the time we last received updates from the database,\nsomeone else already has started a bug report for this issue. ");
                URL col = null;
                return col;
            }
            if (status == Cloud.BugFilingStatus.FILE_BUG) {
                URL u = this.getBugFilingLink(b);
                if (u != null && DBCloud.firstTimeDoing(HAS_FILED_BUGS)) {
                    String bugFilingNote = String.format(SystemProperties.getProperty("findbugs.filebug.note", ""), new Object[0]);
                    int response = this.bugCollection.getProject().getGuiCallback().showConfirmDialog("This looks like the first time you've filed a bug from this machine. Please:\n * Please check the component the issue is assigned to; we sometimes get it wrong.\n * Try to figure out the right person to assign it to.\n * Provide the information needed to understand the issue.\n" + bugFilingNote + "Note that classifying an issue is distinct from (and lighter weight than) filing a bug.", "Do you want to file a bug report", 0);
                    if (response != 0) {
                        URL uRL4 = null;
                        return uRL4;
                    }
                }
                if (u != null) {
                    this.insertPendingRecord(c, bd, System.currentTimeMillis(), this.findbugsUser);
                }
                uRL = u;
                return uRL;
            }
            assert (status == Cloud.BugFilingStatus.FILE_AGAIN);
            DBCloud.alreadyDone(HAS_FILED_BUGS);
            URL u = this.getBugFilingLink(b);
            if (u != null) {
                this.insertPendingRecord(c, bd, System.currentTimeMillis(), this.findbugsUser);
            }
            uRL = u;
            return uRL;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            Util.closeSilently(c);
        }
        return null;
    }

    @CheckForNull
    private URL getBugViewLink(String bugNumber) {
        String viewLinkPattern = SystemProperties.getProperty("findbugs.viewbug.link");
        if (viewLinkPattern == null) {
            return null;
        }
        this.firstBugRequest = false;
        String u = String.format(viewLinkPattern, bugNumber);
        try {
            return new URL(u);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private URL getBugFilingLink(BugInstance b) throws MalformedURLException {
        Object u;
        if (BUG_LINK_FORMAT == null) {
            return null;
        }
        String report = this.getBugReport(b);
        String component = this.getUserDesignation(b) == Cloud.UserDesignation.BAD_ANALYSIS && COMPONENT_FOR_BAD_ANALYSIS != null ? COMPONENT_FOR_BAD_ANALYSIS : this.getBugComponent(b.getPrimaryClass().getClassName().replace('.', '/'));
        String summary = b.getMessageWithoutPrefix() + " in " + b.getPrimaryClass().getSourceFileName();
        int maxURLLength = 1999;
        if (this.firstBugRequest) {
            if (BUG_LOGIN_LINK != null && BUG_LOGIN_MSG != null) {
                u = new URL(String.format(BUG_LOGIN_LINK, new Object[0]));
                if (!this.bugCollection.getProject().getGuiCallback().showDocument((URL)u)) {
                    return null;
                }
                int r = this.bugCollection.getProject().getGuiCallback().showConfirmDialog(BUG_LOGIN_MSG, "Logging into bug tracker...", 2);
                if (r == 2) {
                    return null;
                }
            } else {
                maxURLLength = maxURLLength * 2 / 3;
            }
        }
        this.firstBugRequest = false;
        u = String.format(BUG_LINK_FORMAT, component, DBCloud.urlEncode(summary), DBCloud.urlEncode(report));
        if (((String)u).length() > maxURLLength) {
            report = this.getBugReportShorter(b);
            u = String.format(BUG_LINK_FORMAT, component, DBCloud.urlEncode(summary), DBCloud.urlEncode(report));
            if (((String)u).length() > maxURLLength) {
                report = this.getBugReportAbridged(b);
                u = String.format(BUG_LINK_FORMAT, component, DBCloud.urlEncode(summary), DBCloud.urlEncode(report));
                String supplemental = "[Can't squeeze this information into the URL used to prepopulate the bug entry\n please cut and paste into the bug report as appropriate]\n\n" + this.getBugReportSourceCode(b) + this.getLineTerminatedUserEvaluation(b) + this.getBugPatternExplanation(b);
                this.bugCollection.getProject().getGuiCallback().displayNonmodelMessage("Cut and paste as needed into bug entry", supplemental);
            }
        }
        return new URL((String)u);
    }

    @Override
    public boolean supportsCloudReports() {
        return true;
    }

    @Override
    public boolean supportsBugLinks() {
        return BUG_LINK_FORMAT != null;
    }

    @Override
    public String getCloudReport(BugInstance b) {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd, yyyy");
        StringBuilder builder = new StringBuilder();
        BugData bd = this.getBugData(b);
        long firstSeen = bd.firstSeen;
        if (firstSeen < Long.MAX_VALUE) {
            builder.append(String.format("First seen %s\n", format.format(new Timestamp(firstSeen))));
        }
        I18N i18n = I18N.instance();
        boolean canSeeCommentsByOthers = bd.canSeeCommentsByOthers();
        if (canSeeCommentsByOthers && bd.bugStatus != null) {
            builder.append(bd.bugComponentName);
            if (bd.bugAssignedTo == null) {
                builder.append("\nBug status is " + bd.bugStatus);
            } else {
                builder.append("\nBug assigned to " + bd.bugAssignedTo + ", status is " + bd.bugStatus);
            }
            builder.append("\n\n");
        }
        for (BugDesignation d : bd.getUniqueDesignations()) {
            if (!this.findbugsUser.equals(d.getUser()) && !canSeeCommentsByOthers) continue;
            builder.append(String.format("%s @ %s: %s\n", d.getUser(), format.format(new Timestamp(d.getTimestamp())), i18n.getUserDesignation(d.getDesignationKey())));
            String annotationText = d.getAnnotationText();
            if (annotationText == null || annotationText.length() <= 0) continue;
            builder.append(annotationText);
            builder.append("\n\n");
        }
        return builder.toString();
    }

    @Override
    public void storeUserAnnotation(BugInstance bugInstance) {
        this.storeUserAnnotation(this.getBugData(bugInstance), bugInstance.getNonnullUserDesignation());
        this.updatedIssue(bugInstance);
    }

    @Override
    public boolean supportsSourceLinks() {
        return this.sourceFileLinkPattern != null;
    }

    @Override
    @CheckForNull
    public URL getSourceLink(BugInstance b) {
        if (this.sourceFileLinkPattern == null) {
            return null;
        }
        SourceLineAnnotation src = b.getPrimarySourceLineAnnotation();
        String fileName = src.getSourcePath();
        int startLine = src.getStartLine();
        Matcher m = this.sourceFileLinkPattern.matcher(fileName);
        boolean isMatch = m.matches();
        if (isMatch) {
            try {
                URL link = startLine > 0 ? new URL(String.format(this.sourceFileLinkFormatWithLine, m.group(1), startLine, startLine - 10)) : new URL(String.format(this.sourceFileLinkFormat, m.group(1)));
                return link;
            }
            catch (MalformedURLException e) {
                AnalysisContext.logError("Error generating source link for " + src, e);
            }
        }
        return null;
    }

    @Override
    public String getSourceLinkToolTip(BugInstance b) {
        return this.sourceFileLinkToolTip;
    }

    @Override
    public Cloud.BugFilingStatus getBugLinkStatus(BugInstance b) {
        BugData bd = this.getBugData(b);
        String link = bd.bugLink;
        if (link == null || link.length() == 0 || link.equals(NONE)) {
            return Cloud.BugFilingStatus.FILE_BUG;
        }
        if (link.equals(PENDING)) {
            if (this.findbugsUser.equals(bd.filedBy)) {
                return Cloud.BugFilingStatus.FILE_AGAIN;
            }
            long whenFiled = bd.bugFiled;
            if (this.pendingStatusHasExpired(whenFiled)) {
                return Cloud.BugFilingStatus.FILE_BUG;
            }
            return Cloud.BugFilingStatus.BUG_PENDING;
        }
        try {
            Integer.parseInt(link);
            return Cloud.BugFilingStatus.VIEW_BUG;
        }
        catch (RuntimeException e) {
            return Cloud.BugFilingStatus.NA;
        }
    }

    private boolean pendingStatusHasExpired(long whenFiled) {
        return System.currentTimeMillis() - whenFiled > 3600000L;
    }

    @Override
    public void bugFiled(BugInstance b, Object bugLink) {
        this.checkForShutdown();
        if (this.bugAlreadyFiled(b)) {
            return;
        }
        this.queue.add(new FileBug(b));
        this.updatedStatus();
    }

    void setErrorMsg(String msg) {
        this.errorMsg = msg;
        this.errorTime = System.currentTimeMillis();
        this.updatedStatus();
    }

    void clearErrorMsg() {
        this.errorMsg = null;
        this.updatedStatus();
    }

    @Override
    public String getStatusMsg() {
        if (this.errorMsg != null) {
            if (this.errorTime + 120000L > System.currentTimeMillis()) {
                this.errorMsg = null;
            } else {
                return this.errorMsg + "; " + this.getStatusMsg0();
            }
        }
        return this.getStatusMsg0();
    }

    public String getStatusMsg0() {
        SimpleDateFormat format = new SimpleDateFormat("h:mm a");
        int numToSync = this.queue.size();
        if (numToSync > 0) {
            return String.format("%d remain to be synchronized", numToSync);
        }
        if (this.resync != null && this.resync.after(this.lastUpdate)) {
            return String.format("%d updates received from db at %s", this.resyncCount, format.format(this.resync));
        }
        if (this.updatesSentToDatabase == 0) {
            return String.format("%d issues synchronized with database", this.idMap.size());
        }
        return String.format("%d classifications/bug filings sent to db, last updated at %s", this.updatesSentToDatabase, format.format(this.lastUpdate));
    }

    @Override
    public void printCloudSummary(PrintWriter w, Iterable<BugInstance> bugs, String[] packagePrefixes) {
        Multiset<String> evaluations = new Multiset<String>();
        Multiset<String> designations = new Multiset<String>();
        Multiset<String> bugStatus = new Multiset<String>();
        int[] issuesWithThisManyReviews = new int[100];
        I18N i18n = I18N.instance();
        HashSet<String> hashCodes = new HashSet<String>();
        for (BugInstance b : bugs) {
            hashCodes.add(b.getInstanceHash());
        }
        int packageCount = 0;
        int classCount = 0;
        int ncss = 0;
        ProjectStats projectStats = this.bugCollection.getProjectStats();
        for (PackageStats ps : projectStats.getPackageStats()) {
            if (!ClassName.matchedPrefixes(packagePrefixes, ps.getPackageName()) || ps.size() <= 0 || ps.getNumClasses() <= 0) continue;
            ++packageCount;
            ncss += ps.size();
            classCount += ps.getNumClasses();
        }
        if (packagePrefixes != null && packagePrefixes.length > 0) {
            String lst = Arrays.asList(packagePrefixes).toString();
            w.println("Code analyzed in " + lst.substring(1, lst.length() - 1));
        } else {
            w.println("Code analyzed");
        }
        if (classCount == 0) {
            w.println("No classes were analyzed");
        } else {
            w.printf("%,7d packages\n%,7d classes\n%,7d thousands of lines of non-commenting source statements\n", packageCount, classCount, (ncss + 999) / 1000);
        }
        w.println();
        int count = 0;
        int notInCloud = 0;
        for (String hash : hashCodes) {
            int numReviews;
            BugData bd = this.instanceMap.get(hash);
            if (bd == null) {
                ++notInCloud;
                continue;
            }
            ++count;
            HashSet<String> reviewers = new HashSet<String>();
            if (bd.bugStatus != null) {
                bugStatus.add(bd.bugStatus);
            }
            for (BugDesignation d : bd.designations) {
                if (!reviewers.add(d.getUser())) continue;
                evaluations.add(d.getUser());
                designations.add(i18n.getUserDesignation(d.getDesignationKey()));
            }
            int n = numReviews = Math.min(reviewers.size(), issuesWithThisManyReviews.length - 1);
            issuesWithThisManyReviews[n] = issuesWithThisManyReviews[n] + 1;
        }
        if (count == 0) {
            w.printf("None of the %d issues in the current view are in the cloud\n\n", notInCloud);
            return;
        }
        if (notInCloud == 0) {
            w.printf("Summary for %d issues that are in the current view\n\n", count);
        } else {
            w.printf("Summary for %d issues that are in the current view and cloud (%d not in cloud)\n\n", count, notInCloud);
        }
        w.println("People who have performed the most reviews");
        DBCloud.printLeaderBoard(w, evaluations, 9, this.findbugsUser, true, "reviewer");
        w.println("\nDistribution of evaluations");
        DBCloud.printLeaderBoard(w, designations, 100, " --- ", false, "designation");
        w.println("\nDistribution of bug status");
        DBCloud.printLeaderBoard(w, bugStatus, 100, " --- ", false, "status of filed bug");
        w.println("\nDistribution of number of reviews");
        for (int i = 0; i < issuesWithThisManyReviews.length; ++i) {
            if (issuesWithThisManyReviews[i] <= 0) continue;
            w.printf("%4d  with %3d review", issuesWithThisManyReviews[i], i);
            if (i != 1) {
                w.print("s");
            }
            w.println();
        }
    }

    static void printLeaderBoard(PrintWriter w, Multiset<String> evaluations, int maxRows, String alwaysPrint, boolean listRank, String title) {
        if (listRank) {
            w.printf("%3s %4s %s\n", "rnk", "num", title);
        } else {
            w.printf("%4s %s\n", "num", title);
        }
        DBCloud.printLeaderBoard2(w, evaluations, maxRows, alwaysPrint, listRank ? "%3d %4d %s\n" : "%2$4d %3$s\n", title);
    }

    static void printLeaderBoard2(PrintWriter w, Multiset<String> evaluations, int maxRows, String alwaysPrint, String format, String title) {
        int row = 1;
        int position = 0;
        int previousScore = -1;
        boolean foundAlwaysPrint = false;
        for (Map.Entry<String, Integer> e : evaluations.entriesInDecreasingFrequency()) {
            int num = e.getValue();
            if (num != previousScore) {
                position = row;
                previousScore = num;
            }
            String key = e.getKey();
            if (LEADERBOARD_BLACKLIST_PATTERN != null && LEADERBOARD_BLACKLIST_PATTERN.matcher(key).matches()) continue;
            boolean shouldAlwaysPrint = key.equals(alwaysPrint);
            if (row <= maxRows || shouldAlwaysPrint) {
                w.printf(format, position, num, key);
            }
            if (shouldAlwaysPrint) {
                foundAlwaysPrint = true;
            }
            if (++row < maxRows) continue;
            if (alwaysPrint == null) break;
            if (!foundAlwaysPrint) continue;
            w.printf("Total of %d %ss\n", evaluations.numKeys(), title);
            break;
        }
    }

    @Override
    public boolean getIWillFix(BugInstance b) {
        if (super.getIWillFix(b)) {
            return true;
        }
        BugData bd = this.getBugData(b);
        return bd != null && this.findbugsUser.equals(bd.bugAssignedTo);
    }

    public boolean getBugIsUnassigned(BugInstance b) {
        BugData bd = this.getBugData(b);
        return bd != null && bd.inDatabase && this.getBugLinkStatus(b) == Cloud.BugFilingStatus.VIEW_BUG && ("NEW".equals(bd.bugStatus) || bd.bugAssignedTo == null || bd.bugAssignedTo.length() == 0);
    }

    public boolean getWillNotBeFixed(BugInstance b) {
        BugData bd = this.getBugData(b);
        return bd != null && bd.inDatabase && this.getBugLinkStatus(b) == Cloud.BugFilingStatus.VIEW_BUG && "WILL_NOT_FIX".equals(bd.bugStatus);
    }

    @Override
    public boolean supportsCloudSummaries() {
        return true;
    }

    @Override
    public boolean canStoreUserAnnotation(BugInstance bugInstance) {
        return !this.skipBug(bugInstance);
    }

    @Override
    @CheckForNull
    public String claimedBy(BugInstance b) {
        BugData bd = this.getBugData(b);
        if (bd == null) {
            return null;
        }
        for (BugDesignation designation : bd.getUniqueDesignations()) {
            if (!"I_WILL_FIX".equals(designation.getDesignationKey())) continue;
            return designation.getUser();
        }
        return null;
    }

    static {
        MAX_DB_RANK = SystemProperties.getInt("findbugs.db.maxrank", 12);
        BUG_NOTE = SystemProperties.getProperty("findbugs.bugnote");
        POSTMORTEM_NOTE = SystemProperties.getProperty("findbugs.postmortem.note");
        POSTMORTEM_RANK = SystemProperties.getInt("findbugs.postmortem.maxRank", 4);
        BUG_LINK_FORMAT = SystemProperties.getProperty("findbugs.filebug.link");
        BUG_LOGIN_LINK = SystemProperties.getProperty("findbugs.filebug.login");
        BUG_LOGIN_MSG = SystemProperties.getProperty("findbugs.filebug.loginMsg");
        COMPONENT_FOR_BAD_ANALYSIS = SystemProperties.getProperty("findbugs.filebug.badAnalysisComponent");
        LEADERBOARD_BLACKLIST = SystemProperties.getProperty("findbugs.leaderboard.blacklist");
        Pattern p = null;
        if (LEADERBOARD_BLACKLIST != null) {
            try {
                p = Pattern.compile(LEADERBOARD_BLACKLIST.replace(',', '|'));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LEADERBOARD_BLACKLIST_PATTERN = p;
    }

    static class SourceLine {
        final int line;
        final String text;

        public SourceLine(int line, String text) {
            this.line = line;
            this.text = text;
        }
    }

    static class StoreUserAnnotation
    implements Update {
        final BugData data;
        final BugDesignation designation;

        public StoreUserAnnotation(BugData data, BugDesignation designation) {
            this.data = data;
            this.designation = designation;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            t.newEvaluation(this.data, new BugDesignation(this.designation));
        }
    }

    class StoreNewBug
    implements Update {
        final BugInstance bug;
        final long analysisTime;

        public StoreNewBug(BugInstance bug, long analysisTime) {
            this.bug = bug;
            this.analysisTime = analysisTime;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            long timestamp;
            BugData data = DBCloud.this.getBugData(this.bug.getInstanceHash());
            if (data.lastSeen < this.analysisTime && FindBugs.validTimestamp(this.analysisTime)) {
                data.lastSeen = this.analysisTime;
            }
            data.firstSeen = timestamp = DBCloud.this.bugCollection.getAppVersionFromSequenceNumber(this.bug.getFirstVersion()).getTimestamp();
            if (data.inDatabase) {
                return;
            }
            t.newBug(this.bug);
            data.inDatabase = true;
        }
    }

    class FileBug
    implements Update {
        final BugData bd;

        public FileBug(BugInstance bug) {
            this.bd = DBCloud.this.getBugData(bug.getInstanceHash());
            if (this.bd == null || !this.bd.inDatabase) {
                throw new IllegalArgumentException();
            }
            this.bd.bugFiled = System.currentTimeMillis();
            this.bd.bugLink = DBCloud.PENDING;
            this.bd.filedBy = DBCloud.this.findbugsUser;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            t.fileBug(this.bd);
        }
    }

    static class DatabaseSyncShutdownException
    extends RuntimeException {
        DatabaseSyncShutdownException() {
        }
    }

    static class ShutdownTask
    implements Update {
        ShutdownTask() {
        }

        public void execute(DatabaseSyncTask t) {
            throw new DatabaseSyncShutdownException();
        }
    }

    static interface Update {
        public void execute(DatabaseSyncTask var1) throws SQLException;
    }

    class DatabaseSyncTask
    implements Runnable {
        int handled;
        Connection c;

        DatabaseSyncTask() {
        }

        public void establishConnection() throws SQLException {
            if (this.c != null) {
                return;
            }
            this.c = DBCloud.this.getConnection();
        }

        public void closeConnection() throws SQLException {
            if (this.c == null) {
                return;
            }
            this.c.close();
            this.c = null;
        }

        public void run() {
            try {
                while (!DBCloud.this.shutdown) {
                    Update u = DBCloud.this.queue.poll(10L, TimeUnit.SECONDS);
                    if (u == null) {
                        this.closeConnection();
                        continue;
                    }
                    this.establishConnection();
                    u.execute(this);
                    if (this.handled++ % 100 != 0 && !DBCloud.this.queue.isEmpty()) continue;
                    DBCloud.this.updatedStatus();
                }
            }
            catch (DatabaseSyncShutdownException e) {
            }
            catch (RuntimeException e) {
                DBCloud.this.displayMessage("Runtime exception; database connection shutdown", e);
            }
            catch (SQLException e) {
                DBCloud.this.displayMessage("SQL exception; database connection shutdown", e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.closeConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public void newEvaluation(BugData data, BugDesignation bd) {
            if (!data.inDatabase) {
                return;
            }
            try {
                data.designations.add(bd);
                if (bd.getUser() == null) {
                    bd.setUser(DBCloud.this.findbugsUser);
                }
                if (bd.getAnnotationText() == null) {
                    bd.setAnnotationText("");
                }
                PreparedStatement insertEvaluation = this.c.prepareStatement("INSERT INTO findbugs_evaluation (issueId, who, designation, comment, time) VALUES (?,?,?,?,?)", 1);
                Timestamp date = new Timestamp(bd.getTimestamp());
                int col = 1;
                insertEvaluation.setInt(col++, data.id);
                insertEvaluation.setString(col++, bd.getUser());
                insertEvaluation.setString(col++, bd.getDesignationKey());
                insertEvaluation.setString(col++, bd.getAnnotationText());
                insertEvaluation.setTimestamp(col++, date);
                insertEvaluation.executeUpdate();
                ResultSet rs = insertEvaluation.getGeneratedKeys();
                if (rs.next()) {
                    int id = rs.getInt(1);
                    DBCloud.this.bugDesignationId.put(bd, id);
                }
                rs.close();
                insertEvaluation.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
            DBCloud.this.lastUpdate = new Date();
            ++DBCloud.this.updatesSentToDatabase;
        }

        public void newBug(BugInstance b) {
            try {
                BugData bug = DBCloud.this.getBugData(b.getInstanceHash());
                if (bug.inDatabase) {
                    return;
                }
                PreparedStatement insertBugData = this.c.prepareStatement("INSERT INTO findbugs_issue (firstSeen, lastSeen, hash, bugPattern, priority, primaryClass) VALUES (?,?,?,?,?,?)", 1);
                int col = 1;
                insertBugData.setTimestamp(col++, new Timestamp(bug.firstSeen));
                insertBugData.setTimestamp(col++, new Timestamp(bug.lastSeen));
                insertBugData.setString(col++, bug.instanceHash);
                insertBugData.setString(col++, b.getBugPattern().getType());
                insertBugData.setInt(col++, b.getPriority());
                insertBugData.setString(col++, b.getPrimaryClass().getClassName());
                insertBugData.executeUpdate();
                ResultSet rs = insertBugData.getGeneratedKeys();
                if (rs.next()) {
                    bug.id = rs.getInt(1);
                    bug.inDatabase = true;
                }
                rs.close();
                insertBugData.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
        }

        public void storeFirstSeen(BugData bug) {
            try {
                PreparedStatement insertBugData = this.c.prepareStatement("UPDATE  findbugs_issue SET firstSeen = ? WHERE id = ?");
                Timestamp date = new Timestamp(bug.firstSeen);
                int col = 1;
                insertBugData.setTimestamp(col++, date);
                insertBugData.setInt(col++, bug.id);
                insertBugData.executeUpdate();
                insertBugData.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
        }

        public void storeLastSeen(BugData bug, long timestamp) {
            try {
                PreparedStatement insertBugData = this.c.prepareStatement("UPDATE  findbugs_issue SET lastSeen = ? WHERE id = ?");
                Timestamp date = new Timestamp(timestamp);
                int col = 1;
                insertBugData.setTimestamp(col++, date);
                insertBugData.setInt(col++, bug.id);
                insertBugData.executeUpdate();
                insertBugData.close();
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problems looking up user annotations", e);
            }
        }

        public void fileBug(BugData bug) {
            try {
                DBCloud.this.insertPendingRecord(this.c, bug, bug.bugFiled, bug.filedBy);
            }
            catch (Exception e) {
                DBCloud.this.displayMessage("Problem filing bug", e);
            }
            DBCloud.this.lastUpdate = new Date();
            ++DBCloud.this.updatesSentToDatabase;
        }
    }

    class PopulateBugs
    implements Update {
        final boolean performFullLoad;

        PopulateBugs(boolean performFullLoad) {
            this.performFullLoad = performFullLoad;
        }

        public void execute(DatabaseSyncTask t) throws SQLException {
            Object designation;
            if (DBCloud.this.startShutdown) {
                return;
            }
            String commonPrefix = null;
            int updates = 0;
            if (this.performFullLoad) {
                for (BugInstance b : DBCloud.this.bugCollection.getCollection()) {
                    if (DBCloud.this.skipBug(b)) continue;
                    commonPrefix = Util.commonPrefix(commonPrefix, b.getPrimaryClass().getClassName());
                    DBCloud.this.getBugData((String)b.getInstanceHash()).bugs.add(b);
                }
                if (commonPrefix == null) {
                    commonPrefix = "<no bugs>";
                } else if (commonPrefix.length() > 128) {
                    commonPrefix = commonPrefix.substring(0, 128);
                }
            }
            try {
                int id;
                int col;
                ResultSet rs;
                PreparedStatement ps;
                long startTime = System.currentTimeMillis();
                Connection c = DBCloud.this.getConnection();
                if (this.performFullLoad) {
                    ps = c.prepareStatement("SELECT id, hash, firstSeen, lastSeen FROM findbugs_issue");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        col = 1;
                        id = rs.getInt(col++);
                        String hash = rs.getString(col++);
                        Timestamp firstSeen = rs.getTimestamp(col++);
                        Timestamp lastSeen = rs.getTimestamp(col++);
                        DBCloud.this.loadDatabaseInfo(hash, id, firstSeen.getTime(), lastSeen.getTime());
                    }
                    rs.close();
                    ps.close();
                }
                if (DBCloud.this.startShutdown) {
                    return;
                }
                ps = c.prepareStatement("SELECT id, issueId, who, designation, comment, time FROM findbugs_evaluation");
                rs = ps.executeQuery();
                while (rs.next()) {
                    BugDesignation bd;
                    col = 1;
                    id = rs.getInt(col++);
                    int issueId = rs.getInt(col++);
                    String who = rs.getString(col++);
                    designation = rs.getString(col++);
                    String comment = rs.getString(col++);
                    Timestamp when = rs.getTimestamp(col++);
                    BugData data = DBCloud.this.idMap.get(issueId);
                    if (data == null || !data.designations.add(bd = new BugDesignation((String)designation, when.getTime(), comment, who))) continue;
                    DBCloud.this.bugDesignationId.put(bd, id);
                    ++updates;
                    for (BugInstance bug : data.bugs) {
                        DBCloud.this.updatedIssue(bug);
                    }
                }
                rs.close();
                ps.close();
                if (DBCloud.this.startShutdown) {
                    return;
                }
                ps = c.prepareStatement("SELECT hash, bugReportId, whoFiled, whenFiled, status, assignedTo, componentName FROM findbugs_bugreport");
                rs = ps.executeQuery();
                while (rs.next()) {
                    col = 1;
                    String hash = rs.getString(col++);
                    String bugReportId = rs.getString(col++);
                    String whoFiled = rs.getString(col++);
                    Timestamp whenFiled = rs.getTimestamp(col++);
                    String status = rs.getString(col++);
                    String assignedTo = rs.getString(col++);
                    String componentName = rs.getString(col++);
                    BugData data = DBCloud.this.instanceMap.get(hash);
                    if (data == null || Util.nullSafeEquals(data.bugLink, bugReportId) && Util.nullSafeEquals(data.filedBy, whoFiled) && data.bugFiled == whenFiled.getTime() && Util.nullSafeEquals(data.bugAssignedTo, assignedTo) && Util.nullSafeEquals(data.bugStatus, status) && Util.nullSafeEquals(data.bugComponentName, componentName)) continue;
                    data.bugLink = bugReportId;
                    data.filedBy = whoFiled;
                    data.bugFiled = whenFiled.getTime();
                    data.bugAssignedTo = assignedTo;
                    data.bugStatus = status;
                    data.bugComponentName = componentName;
                    ++updates;
                    for (BugInstance bug : data.bugs) {
                        DBCloud.this.updatedIssue(bug);
                    }
                }
                rs.close();
                ps.close();
                if (DBCloud.this.startShutdown) {
                    return;
                }
                if (!invocationRecorded) {
                    long jvmStartTime = StartTime.START_TIME - StartTime.VM_START_TIME;
                    SortedBugCollection sbc = (SortedBugCollection)DBCloud.this.bugCollection;
                    long findbugsStartTime = sbc.getTimeStartedLoading() - StartTime.START_TIME;
                    URL findbugsURL = PluginLoader.getCoreResource("findbugs.xml");
                    String loadURL = findbugsURL == null ? "" : findbugsURL.toString();
                    long initialLoadTime = sbc.getTimeFinishedLoading() - sbc.getTimeStartedLoading();
                    long lostTime = startTime - sbc.getTimeStartedLoading();
                    long initialSyncTime = System.currentTimeMillis() - sbc.getTimeFinishedLoading();
                    String os = SystemProperties.getProperty("os.name", "");
                    String osVersion = SystemProperties.getProperty("os.version");
                    String jvmVersion = SystemProperties.getProperty("java.runtime.version");
                    if (osVersion != null) {
                        os = os + " " + osVersion;
                    }
                    PreparedStatement insertSession = c.prepareStatement("INSERT INTO findbugs_invocation (who, entryPoint, dataSource, fbVersion, os, jvmVersion, jvmLoadTime, findbugsLoadTime, analysisLoadTime, initialSyncTime, numIssues, startTime, commonPrefix) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)", 1);
                    Timestamp now = new Timestamp(startTime);
                    int col2 = 1;
                    insertSession.setString(col2++, DBCloud.this.findbugsUser);
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(loadURL, 128));
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(sbc.getDataSource(), 128));
                    insertSession.setString(col2++, Version.RELEASE);
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(os, 128));
                    insertSession.setString(col2++, DBCloud.limitToMaxLength(jvmVersion, 64));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(jvmStartTime));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(findbugsStartTime));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(initialLoadTime));
                    insertSession.setLong(col2++, DBCloud.this.boundDuration(initialSyncTime));
                    insertSession.setInt(col2++, DBCloud.this.bugCollection.getCollection().size());
                    insertSession.setTimestamp(col2++, now);
                    insertSession.setString(col2++, commonPrefix);
                    int rowCount = insertSession.executeUpdate();
                    rs = insertSession.getGeneratedKeys();
                    if (rs.next()) {
                        DBCloud.this.sessionId = rs.getInt(1);
                    }
                    insertSession.close();
                    rs.close();
                    invocationRecorded = true;
                }
                c.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCloud.this.displayMessage("problem bulk loading database", e);
            }
            if (DBCloud.this.startShutdown) {
                return;
            }
            if (!this.performFullLoad) {
                DBCloud.this.attemptedResync = new Date();
                if (updates > 0) {
                    DBCloud.this.resync = DBCloud.this.attemptedResync;
                    DBCloud.this.resyncCount = updates;
                }
            } else {
                long stillPresentAt = DBCloud.this.bugCollection.getTimestamp();
                for (BugInstance b : DBCloud.this.bugCollection.getCollection()) {
                    if (DBCloud.this.skipBug(b)) continue;
                    BugData bd = DBCloud.this.getBugData(b.getInstanceHash());
                    if (!bd.inDatabase) {
                        DBCloud.this.storeNewBug(b, stillPresentAt);
                        continue;
                    }
                    long firstVersion = b.getFirstVersion();
                    long firstSeen = DBCloud.this.bugCollection.getAppVersionFromSequenceNumber(firstVersion).getTimestamp();
                    if (FindBugs.validTimestamp(firstSeen) && (firstSeen < bd.firstSeen || !FindBugs.validTimestamp(bd.firstSeen))) {
                        bd.firstSeen = firstSeen;
                        DBCloud.this.storeFirstSeen(bd);
                    } else if (FindBugs.validTimestamp(stillPresentAt) && stillPresentAt > bd.lastSeen + LAST_SEEN_UPDATE_WINDOW) {
                        DBCloud.this.storeLastSeen(bd, stillPresentAt);
                    }
                    if ((designation = bd.getPrimaryDesignation()) == null) continue;
                    b.setUserDesignation(new BugDesignation((BugDesignation)designation));
                }
                DBCloud.this.initialSyncDone.countDown();
                assert (!DBCloud.this.scheduled);
                if (DBCloud.this.startShutdown) {
                    return;
                }
                long delay = 600000L;
                if (!DBCloud.this.scheduled) {
                    try {
                        DBCloud.this.resyncTimer.schedule(new TimerTask(){

                            public void run() {
                                if (DBCloud.this.attemptedResync == null || DBCloud.this.lastUpdate.after(DBCloud.this.attemptedResync) || DBCloud.this.numSkipped++ > 6) {
                                    DBCloud.this.numSkipped = 0;
                                    DBCloud.this.queue.add(new PopulateBugs(false));
                                }
                            }
                        }, delay, delay);
                    }
                    catch (Exception e) {
                        AnalysisContext.logError("Error scheduling resync", e);
                    }
                }
                DBCloud.this.scheduled = true;
            }
            DBCloud.this.updatedStatus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BugData {
        final String instanceHash;
        int id;
        boolean inDatabase;
        long firstSeen;
        String bugLink = "none";
        String filedBy;
        String bugStatus;
        String bugAssignedTo;
        String bugComponentName;
        long bugFiled = Long.MAX_VALUE;
        SortedSet<BugDesignation> designations = new TreeSet<BugDesignation>();
        Collection<BugInstance> bugs = new LinkedHashSet<BugInstance>();
        long lastSeen;

        public BugData(String instanceHash) {
            this.instanceHash = instanceHash;
        }

        @CheckForNull
        BugDesignation getPrimaryDesignation() {
            for (BugDesignation bd : this.designations) {
                if (!DBCloud.this.findbugsUser.equals(bd.getUser())) continue;
                return bd;
            }
            return null;
        }

        @CheckForNull
        BugDesignation getUserDesignation() {
            for (BugDesignation d : this.designations) {
                if (!DBCloud.this.findbugsUser.equals(d.getUser())) continue;
                return new BugDesignation(d);
            }
            return null;
        }

        Collection<BugDesignation> getUniqueDesignations() {
            if (this.designations.isEmpty()) {
                return Collections.emptyList();
            }
            HashSet<String> reviewers = new HashSet<String>();
            ArrayList<BugDesignation> result = new ArrayList<BugDesignation>(this.designations.size());
            for (BugDesignation d : this.designations) {
                if (!reviewers.add(d.getUser())) continue;
                result.add(d);
            }
            return result;
        }

        Set<String> getReviewers() {
            HashSet<String> reviewers = new HashSet<String>();
            for (BugDesignation bd : this.designations) {
                reviewers.add(bd.getUser());
            }
            reviewers.remove("");
            reviewers.remove(null);
            return reviewers;
        }

        boolean isClaimed() {
            for (BugDesignation bd : this.getUniqueDesignations()) {
                if (!bd.getDesignationKey().equals(Cloud.UserDesignation.I_WILL_FIX.name())) continue;
                return true;
            }
            return false;
        }

        BugDesignation getNonnullUserDesignation() {
            BugDesignation d = this.getUserDesignation();
            if (d != null) {
                return d;
            }
            d = new BugDesignation(Cloud.UserDesignation.UNCLASSIFIED.name(), System.currentTimeMillis(), "", DBCloud.this.findbugsUser);
            return d;
        }

        public boolean canSeeCommentsByOthers() {
            switch (DBCloud.this.mode) {
                case SECRET: {
                    return false;
                }
                case COMMUNAL: {
                    return true;
                }
                case VOTING: {
                    return this.hasVoted();
                }
            }
            throw new IllegalStateException();
        }

        public boolean hasVoted() {
            for (BugDesignation bd : this.designations) {
                if (!DBCloud.this.findbugsUser.equals(bd.getUser())) continue;
                return true;
            }
            return false;
        }
    }
}

