/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.util.MapCache;
import edu.umd.cs.findbugs.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNumber
implements Comparable<ValueNumber> {
    static MapCache<ValueNumber, ValueNumber> cache = new MapCache(200);
    static int valueNumbersCreated = 0;
    static int valueNumbersReused = 0;
    final int number;
    final int flags;
    public static final int RETURN_VALUE = 1;
    public static final int ARRAY_VALUE = 2;
    public static final int CONSTANT_CLASS_OBJECT = 4;
    public static final int PHI_NODE = 8;
    public static final int CONSTANT_VALUE = 16;

    public static synchronized ValueNumber createValueNumber(int number, int flags) {
        ValueNumber probe = new ValueNumber(number, flags);
        ValueNumber result = (ValueNumber)cache.get(probe);
        if (result != null) {
            ++valueNumbersReused;
            return result;
        }
        cache.put(probe, probe);
        ++valueNumbersCreated;
        return probe;
    }

    public static ValueNumber createValueNumber(int number) {
        return ValueNumber.createValueNumber(number, 0);
    }

    private ValueNumber(int number) {
        this.number = number;
        this.flags = 0;
    }

    private ValueNumber(int number, int flags) {
        this.number = number;
        this.flags = flags;
    }

    public int getNumber() {
        return this.number;
    }

    public int getFlags() {
        return this.flags;
    }

    @Deprecated
    public void setFlags(int flags) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setFlag(int flag) {
        throw new UnsupportedOperationException();
    }

    public boolean hasFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public String toString() {
        if (this.flags != 0) {
            return this.number + "(" + this.flags + "),";
        }
        return this.number + ",";
    }

    public int hashCode() {
        return this.number * 17 + this.flags;
    }

    public boolean equals(Object o) {
        if (o instanceof ValueNumber) {
            return this.number == ((ValueNumber)o).number && this.flags == ((ValueNumber)o).flags;
        }
        return false;
    }

    @Override
    public int compareTo(ValueNumber other) {
        int result = this.number - other.number;
        if (result != 0) {
            return result;
        }
        return this.flags - other.flags;
    }

    static {
        Util.runLogAtShutdown(new Runnable(){

            public void run() {
                System.out.println("Value number statistics: " + valueNumbersCreated + " created, " + valueNumbersReused + " reused");
            }
        });
    }
}

