/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.meta.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierAnnotation {
    public final TypeQualifierValue typeQualifier;
    public final When when;
    public static final TypeQualifierAnnotation OVERRIDES_BUT_NO_ANNOTATION = new TypeQualifierAnnotation(null, null){

        public String toString() {
            return "Overrides but no annotation";
        }
    };
    private static ThreadLocal<DualKeyHashMap<TypeQualifierValue, When, TypeQualifierAnnotation>> instance = new ThreadLocal<DualKeyHashMap<TypeQualifierValue, When, TypeQualifierAnnotation>>(){

        @Override
        protected DualKeyHashMap<TypeQualifierValue, When, TypeQualifierAnnotation> initialValue() {
            return new DualKeyHashMap<TypeQualifierValue, When, TypeQualifierAnnotation>();
        }
    };
    private static final When TOP = null;
    private static final When[][] combineReturnValueMatrix = new When[][]{{When.ALWAYS}, {When.ALWAYS, When.UNKNOWN}, {When.ALWAYS, When.UNKNOWN, When.MAYBE}, {TOP, TOP, When.NEVER, When.NEVER}};
    private static final When[][] combineParameterMatrix = new When[][]{{When.ALWAYS}, {When.UNKNOWN, When.UNKNOWN}, {When.MAYBE, When.MAYBE, When.MAYBE}, {When.MAYBE, When.UNKNOWN, When.MAYBE, When.NEVER}};

    private TypeQualifierAnnotation(TypeQualifierValue typeQualifier, When when) {
        this.typeQualifier = typeQualifier;
        this.when = when;
    }

    public static void clearInstance() {
        instance.remove();
    }

    @CheckForNull
    public static TypeQualifierAnnotation combineReturnTypeAnnotations(TypeQualifierAnnotation a, TypeQualifierAnnotation b) {
        return TypeQualifierAnnotation.combineAnnotations(a, b, combineReturnValueMatrix);
    }

    @NonNull
    public static TypeQualifierAnnotation combineParameterAnnotations(TypeQualifierAnnotation a, TypeQualifierAnnotation b) {
        return TypeQualifierAnnotation.combineAnnotations(a, b, combineParameterMatrix);
    }

    private static TypeQualifierAnnotation combineAnnotations(TypeQualifierAnnotation a, TypeQualifierAnnotation b, When[][] mergeMatrix) {
        When combined;
        assert (a.typeQualifier.equals(b.typeQualifier));
        When aWhen = a.when;
        When bWhen = b.when;
        if (aWhen.ordinal() < bWhen.ordinal()) {
            When tmp = aWhen;
            aWhen = bWhen;
            bWhen = tmp;
        }
        if ((combined = mergeMatrix[aWhen.ordinal()][bWhen.ordinal()]) != null) {
            return TypeQualifierAnnotation.getValue(a.typeQualifier, combined);
        }
        return null;
    }

    @NonNull
    public static Collection<TypeQualifierAnnotation> getValues(Map<TypeQualifierValue, When> map) {
        LinkedList<TypeQualifierAnnotation> result = new LinkedList<TypeQualifierAnnotation>();
        for (Map.Entry<TypeQualifierValue, When> e : map.entrySet()) {
            result.add(TypeQualifierAnnotation.getValue(e.getKey(), e.getValue()));
        }
        return result;
    }

    @NonNull
    public static TypeQualifierAnnotation getValue(TypeQualifierValue desc, When when) {
        DualKeyHashMap<TypeQualifierValue, When, TypeQualifierAnnotation> map = instance.get();
        TypeQualifierAnnotation result = map.get(desc, when);
        if (result != null) {
            return result;
        }
        result = new TypeQualifierAnnotation(desc, when);
        map.put(desc, when, result);
        return result;
    }

    public int hashCode() {
        return this.typeQualifier.hashCode() * 37 + this.when.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeQualifierAnnotation)) {
            return false;
        }
        TypeQualifierAnnotation other = (TypeQualifierAnnotation)o;
        return this.typeQualifier.equals(other.typeQualifier) && this.when.equals((Object)other.when);
    }

    public String toString() {
        return this.typeQualifier + ":" + this.when;
    }
}

