/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.WarningComparator;
import edu.umd.cs.findbugs.model.ClassNameRewriter;
import edu.umd.cs.findbugs.model.ClassNameRewriterUtil;
import edu.umd.cs.findbugs.model.IdentityClassNameRewriter;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VersionInsensitiveBugComparator
implements WarningComparator {
    private ClassNameRewriter classNameRewriter = IdentityClassNameRewriter.instance();
    private boolean exactBugPatternMatch = true;
    private boolean comparePriorities = false;

    public void setClassNameRewriter(ClassNameRewriter classNameRewriter) {
        this.classNameRewriter = classNameRewriter;
    }

    public void setComparePriorities(boolean b) {
        this.comparePriorities = b;
    }

    private boolean isBoring(BugAnnotation annotation) {
        return !annotation.isSignificant();
    }

    private static int compareNullElements(Object a, Object b) {
        if (a != null) {
            return 1;
        }
        if (b != null) {
            return -1;
        }
        return 0;
    }

    private static String getCode(String pattern) {
        int sep = pattern.indexOf(95);
        if (sep < 0) {
            return "";
        }
        return pattern.substring(0, sep);
    }

    public int compare(BugInstance lhs, BugInstance rhs) {
        int cmp;
        BugPattern lhsPattern = lhs.getBugPattern();
        BugPattern rhsPattern = rhs.getBugPattern();
        if (lhsPattern == null || rhsPattern == null) {
            String rhsCode;
            String lhsCode = VersionInsensitiveBugComparator.getCode(lhs.getType());
            cmp = lhsCode.compareTo(rhsCode = VersionInsensitiveBugComparator.getCode(rhs.getType()));
            if (cmp != 0) {
                return cmp;
            }
        } else {
            cmp = lhsPattern.getAbbrev().compareTo(rhsPattern.getAbbrev());
            if (cmp != 0) {
                return cmp;
            }
            if (this.isExactBugPatternMatch() && (cmp = lhsPattern.getType().compareTo(rhsPattern.getType())) != 0) {
                return cmp;
            }
        }
        if (this.comparePriorities && (cmp = lhs.getPriority() - rhs.getPriority()) != 0) {
            return cmp;
        }
        FilteringAnnotationIterator lhsIter = new FilteringAnnotationIterator(lhs.annotationIterator());
        FilteringAnnotationIterator rhsIter = new FilteringAnnotationIterator(rhs.annotationIterator());
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            BugAnnotation lhsAnnotation = (BugAnnotation)lhsIter.next();
            BugAnnotation rhsAnnotation = (BugAnnotation)rhsIter.next();
            if (lhsAnnotation.getClass() != rhsAnnotation.getClass()) {
                return lhsAnnotation.getClass().getName().compareTo(rhsAnnotation.getClass().getName());
            }
            if (lhsAnnotation.getClass() == ClassAnnotation.class) {
                String rhsClassName;
                String lhsClassName = this.classNameRewriter.rewriteClassName(((ClassAnnotation)lhsAnnotation).getClassName());
                cmp = lhsClassName.compareTo(rhsClassName = this.classNameRewriter.rewriteClassName(((ClassAnnotation)rhsAnnotation).getClassName()));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhsAnnotation.getClass() == MethodAnnotation.class) {
                MethodAnnotation rhsMethod;
                MethodAnnotation lhsMethod = ClassNameRewriterUtil.convertMethodAnnotation(this.classNameRewriter, (MethodAnnotation)lhsAnnotation);
                cmp = lhsMethod.compareTo(rhsMethod = ClassNameRewriterUtil.convertMethodAnnotation(this.classNameRewriter, (MethodAnnotation)rhsAnnotation));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhsAnnotation.getClass() == FieldAnnotation.class) {
                FieldAnnotation rhsField;
                FieldAnnotation lhsField = ClassNameRewriterUtil.convertFieldAnnotation(this.classNameRewriter, (FieldAnnotation)lhsAnnotation);
                cmp = lhsField.compareTo(rhsField = ClassNameRewriterUtil.convertFieldAnnotation(this.classNameRewriter, (FieldAnnotation)rhsAnnotation));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhsAnnotation.getClass() == StringAnnotation.class) {
                String rhsString;
                String lhsString = ((StringAnnotation)lhsAnnotation).getValue();
                cmp = lhsString.compareTo(rhsString = ((StringAnnotation)rhsAnnotation).getValue());
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhsAnnotation.getClass() == LocalVariableAnnotation.class) {
                String lhsName = ((LocalVariableAnnotation)lhsAnnotation).getName();
                String rhsName = ((LocalVariableAnnotation)rhsAnnotation).getName();
                if (lhsName.equals("?") && rhsName.equals("?") || (cmp = lhsName.compareTo(rhsName)) == 0) continue;
                return cmp;
            }
            if (lhsAnnotation.getClass() == TypeAnnotation.class) {
                String lhsType = ((TypeAnnotation)lhsAnnotation).getTypeDescriptor();
                String rhsType = ((TypeAnnotation)rhsAnnotation).getTypeDescriptor();
                cmp = (lhsType = ClassNameRewriterUtil.rewriteSignature(this.classNameRewriter, lhsType)).compareTo(rhsType = ClassNameRewriterUtil.rewriteSignature(this.classNameRewriter, rhsType));
                if (cmp == 0) continue;
                return cmp;
            }
            if (lhsAnnotation.getClass() == IntAnnotation.class) {
                int rhsValue;
                int lhsValue = ((IntAnnotation)lhsAnnotation).getValue();
                cmp = lhsValue - (rhsValue = ((IntAnnotation)rhsAnnotation).getValue());
                if (cmp == 0) continue;
                return cmp;
            }
            if (this.isBoring(lhsAnnotation)) {
                throw new IllegalStateException("Impossible");
            }
            throw new IllegalStateException("Unknown annotation type: " + lhsAnnotation.getClass().getName());
        }
        if (rhsIter.hasNext()) {
            return -1;
        }
        if (lhsIter.hasNext()) {
            return 1;
        }
        return 0;
    }

    public void setExactBugPatternMatch(boolean exactBugPatternMatch) {
        this.exactBugPatternMatch = exactBugPatternMatch;
    }

    public boolean isExactBugPatternMatch() {
        return this.exactBugPatternMatch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteringAnnotationIterator
    implements Iterator<BugAnnotation> {
        private Iterator<BugAnnotation> iter;
        private BugAnnotation next;

        public FilteringAnnotationIterator(Iterator<BugAnnotation> iter) {
            this.iter = iter;
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public BugAnnotation next() {
            this.findNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            BugAnnotation result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.next == null && this.iter.hasNext()) {
                BugAnnotation candidate = this.iter.next();
                if (VersionInsensitiveBugComparator.this.isBoring(candidate)) continue;
                this.next = candidate;
                break;
            }
        }
    }
}

