/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.util.ClassPathUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactoryCollection {
    private HashMap<String, Plugin> pluginByIdMap = new HashMap();
    private Plugin corePlugin;
    private BugRanker adjustmentBugRanker;
    private ArrayList<DetectorFactory> factoryList = new ArrayList();
    private HashMap<String, DetectorFactory> factoriesByName = new HashMap();
    private HashMap<String, DetectorFactory> factoriesByDetectorClassName = new HashMap();
    private static DetectorFactoryCollection theInstance;
    private static final Object lock;
    private boolean loaded = false;
    private URL[] pluginList;
    private static final Pattern[] findbugsJarNames;
    static final boolean DEBUG_JAWS = false;

    DetectorFactoryCollection() {
    }

    public void setPluginList(URL[] pluginList) {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        this.pluginList = new URL[pluginList.length];
        System.arraycopy(pluginList, 0, this.pluginList, 0, pluginList.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            if (theInstance != null) {
                throw new IllegalStateException();
            }
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetInstance(DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection instance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            theInstance.ensureLoaded();
            return theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection rawInstance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            return theInstance;
        }
    }

    public Iterator<Plugin> pluginIterator() {
        this.ensureLoaded();
        return this.pluginByIdMap.values().iterator();
    }

    public Iterable<Plugin> plugins() {
        this.ensureLoaded();
        return this.pluginByIdMap.values();
    }

    Plugin getCorePlugin() {
        this.ensureLoaded();
        return this.corePlugin;
    }

    BugRanker getAdjustmentBugRanker() {
        this.ensureLoaded();
        return this.adjustmentBugRanker;
    }

    public Plugin getPluginById(String pluginId) {
        this.ensureLoaded();
        return this.pluginByIdMap.get(pluginId);
    }

    public Iterator<DetectorFactory> factoryIterator() {
        this.ensureLoaded();
        return this.factoryList.iterator();
    }

    public DetectorFactory getFactory(String name) {
        this.ensureLoaded();
        return this.factoriesByName.get(name);
    }

    public DetectorFactory getFactoryByClassName(String className) {
        this.ensureLoaded();
        return this.factoriesByDetectorClassName.get(className);
    }

    void registerDetector(DetectorFactory factory) {
        if (FindBugs.DEBUG) {
            System.out.println("Registering detector: " + factory.getFullName());
        }
        String detectorName = factory.getShortName();
        this.factoryList.add(factory);
        this.factoriesByName.put(detectorName, factory);
        this.factoriesByDetectorClassName.put(factory.getFullName(), factory);
    }

    private void determinePlugins() {
        if (this.pluginList != null) {
            return;
        }
        String homeDir = DetectorFactoryCollection.getFindBugsHome();
        if (homeDir == null) {
            this.pluginList = new URL[0];
            return;
        }
        File pluginDir = new File(new File(homeDir), "plugin");
        File[] contentList = pluginDir.listFiles();
        if (contentList == null) {
            this.pluginList = new URL[0];
            return;
        }
        ArrayList<URL> arr = new ArrayList<URL>();
        for (File aContentList : contentList) {
            if (!aContentList.getName().endsWith(".jar")) continue;
            try {
                arr.add(aContentList.toURL());
                if (!FindBugs.DEBUG) continue;
                System.out.println("Found plugin: " + aContentList.toString());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.pluginList = arr.toArray(new URL[arr.size()]);
    }

    private static String inferFindBugsHome() {
        for (Pattern jarNamePattern : findbugsJarNames) {
            File findbugsJar;
            File libDir;
            String findbugsJarCodeBase = ClassPathUtil.findCodeBaseInClassPath(jarNamePattern, SystemProperties.getProperty("java.class.path"));
            if (findbugsJarCodeBase == null || !(libDir = (findbugsJar = new File(findbugsJarCodeBase)).getParentFile()).getName().equals("lib")) continue;
            String fbHome = libDir.getParent();
            FindBugs.setHome(fbHome);
            return fbHome;
        }
        return null;
    }

    public static String getFindBugsHome() {
        String homeDir = FindBugs.getHome();
        if (homeDir == null) {
            homeDir = DetectorFactoryCollection.inferFindBugsHome();
        }
        return homeDir;
    }

    public void ensureLoaded() {
        if (this.loaded) {
            return;
        }
        this.loadPlugins();
    }

    void setPlugins(Plugin[] plugins) {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        for (Plugin plugin : plugins) {
            this.pluginByIdMap.put(plugin.getPluginId(), plugin);
        }
        this.loaded = true;
    }

    void loadPlugins() {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        PluginLoader corePluginLoader = new PluginLoader();
        try {
            this.loadPlugin(corePluginLoader);
            this.corePlugin = corePluginLoader.getPlugin();
        }
        catch (PluginException e) {
            throw new IllegalStateException("Warning: could not load FindBugs core plugin: " + e.toString(), e);
        }
        URL u = PluginLoader.loadFromFindBugsEtcDir("adjustBugrank.txt");
        try {
            this.adjustmentBugRanker = new BugRanker(u);
        }
        catch (IOException e1) {
            AnalysisContext.logError("Unable to parse " + u, e1);
        }
        if (SystemProperties.getBoolean("findbugs.jaws")) {
            URL pluginList = PluginLoader.getCoreResource("pluginlist.properties");
            ArrayList<URL> plugins = new ArrayList<URL>();
            if (pluginList != null) {
                try {
                    String plugin;
                    this.jawsDebugMessage(pluginList.toString());
                    String urlname = pluginList.toString();
                    URL base = pluginList;
                    int pos = urlname.indexOf("!/");
                    if (pos >= 0 && urlname.startsWith("jar:")) {
                        urlname = urlname.substring(4, pos);
                        base = new URL(urlname);
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(pluginList.openStream()));
                    while ((plugin = in.readLine()) != null) {
                        URL url = new URL(base, plugin);
                        try {
                            URLConnection connection = url.openConnection();
                            String contentType = connection.getContentType();
                            this.jawsDebugMessage("contentType : " + contentType);
                            if (connection instanceof HttpURLConnection) {
                                ((HttpURLConnection)connection).disconnect();
                            }
                            plugins.add(url);
                        }
                        catch (Exception e) {
                            this.jawsDebugMessage("error loading " + url + " : " + e.getMessage());
                        }
                    }
                    in.close();
                }
                catch (Exception e) {
                    this.jawsDebugMessage("error : " + e.getMessage());
                }
            }
            this.setPluginList(plugins.toArray(new URL[plugins.size()]));
        } else {
            this.determinePlugins();
        }
        for (final URL url : this.pluginList) {
            try {
                this.jawsDebugMessage("Loading plugin: " + url.toString());
                PluginLoader pluginLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<PluginLoader>(){

                    @Override
                    public PluginLoader run() throws PluginException {
                        return new PluginLoader(url, this.getClass().getClassLoader());
                    }
                });
                this.loadPlugin(pluginLoader);
            }
            catch (PluginException e) {
                this.jawsErrorMessage("Warning: could not load plugin " + url + ": " + e.toString());
                if (!FindBugs.DEBUG) continue;
                e.printStackTrace();
            }
            catch (PrivilegedActionException e) {
                this.jawsErrorMessage("Warning: could not load plugin " + url + ": " + e.toString());
                if (!FindBugs.DEBUG) continue;
                e.printStackTrace();
            }
        }
        this.loaded = true;
    }

    private void jawsDebugMessage(String message) {
        if (FindBugs.DEBUG) {
            System.err.println(message);
        }
    }

    private void jawsErrorMessage(String message) {
        System.err.println(message);
    }

    private void loadPlugin(PluginLoader pluginLoader) throws PluginException {
        Plugin plugin = pluginLoader.getPlugin();
        this.pluginByIdMap.put(plugin.getPluginId(), plugin);
        boolean show = !pluginLoader.isCorePlugin();
        Iterator<DetectorFactory> j = plugin.detectorFactoryIterator();
        while (j.hasNext()) {
            DetectorFactory factory = j.next();
            if (show) {
                this.jawsDebugMessage("Loading detector for " + factory.getFullName());
                show = false;
            }
            this.registerDetector(factory);
        }
        I18N i18n = I18N.instance();
        Iterator<Comparable<BugPattern>> j2 = plugin.bugPatternIterator();
        while (j2.hasNext()) {
            BugPattern bugPattern = j2.next();
            i18n.registerBugPattern(bugPattern);
        }
        j2 = plugin.bugCodeIterator();
        while (j2.hasNext()) {
            BugCode bugCode = (BugCode)j2.next();
            i18n.registerBugCode(bugCode);
        }
    }

    static {
        lock = new Object();
        findbugsJarNames = new Pattern[]{Pattern.compile("findbugs\\.jar$")};
    }
}

