/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.database.model.RuleFailureModel;
import org.sonar.api.database.model.SnapshotSource;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.batch.components.PastViolationsLoader;
import org.sonar.batch.index.ViolationPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependsUpon(value={"END_OF_VIOLATIONS_GENERATION", "START_VIOLATION_TRACKING"})
@DependedUpon(value={"END_OF_VIOLATION_TRACKING"})
public class ViolationPersisterDecorator
implements Decorator {
    private static final String SPACE_CHARS = "\t\n\r ";
    private PastViolationsLoader pastViolationsLoader;
    private ViolationPersister violationPersister;
    List<String> checksums;

    public ViolationPersisterDecorator(PastViolationsLoader pastViolationsLoader, ViolationPersister violationPersister) {
        this.pastViolationsLoader = pastViolationsLoader;
        this.violationPersister = violationPersister;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (context.getViolations().isEmpty()) {
            return;
        }
        List newViolations = context.getViolations();
        List pastViolations = this.pastViolationsLoader.getPastViolations(resource);
        this.checksums = this.getChecksums(this.pastViolationsLoader.getSource(resource));
        Map<Violation, RuleFailureModel> violationMap = this.mapViolations(newViolations, pastViolations);
        for (Violation newViolation : newViolations) {
            String checksum = this.getChecksumForLine(this.checksums, newViolation.getLineId());
            this.violationPersister.saveViolation(context.getProject(), newViolation, violationMap.get(newViolation), checksum);
        }
        this.violationPersister.commit();
        this.checksums.clear();
    }

    Map<Violation, RuleFailureModel> mapViolations(List<Violation> newViolations, List<RuleFailureModel> pastViolations) {
        IdentityHashMap<Violation, RuleFailureModel> violationMap = new IdentityHashMap<Violation, RuleFailureModel>();
        LinkedHashMultimap pastViolationsByRule = LinkedHashMultimap.create();
        for (RuleFailureModel pastViolation : pastViolations) {
            pastViolationsByRule.put((Object)pastViolation.getRuleId(), (Object)pastViolation);
        }
        for (Violation newViolation : newViolations) {
            this.mapViolation(newViolation, this.findPastViolationWithSameLineAndChecksumAndMessage(newViolation, pastViolationsByRule.get((Object)newViolation.getRule().getId())), (Multimap<Integer, RuleFailureModel>)pastViolationsByRule, violationMap);
        }
        if (violationMap.size() != newViolations.size()) {
            for (Violation newViolation : newViolations) {
                if (!this.isNotAlreadyMapped(newViolation, violationMap)) continue;
                this.mapViolation(newViolation, this.findPastViolationWithSameChecksumAndMessage(newViolation, pastViolationsByRule.get((Object)newViolation.getRule().getId())), (Multimap<Integer, RuleFailureModel>)pastViolationsByRule, violationMap);
            }
            for (Violation newViolation : newViolations) {
                if (!this.isNotAlreadyMapped(newViolation, violationMap)) continue;
                this.mapViolation(newViolation, this.findPastViolationWithSameLineAndMessage(newViolation, pastViolationsByRule.get((Object)newViolation.getRule().getId())), (Multimap<Integer, RuleFailureModel>)pastViolationsByRule, violationMap);
            }
        }
        return violationMap;
    }

    private boolean isNotAlreadyMapped(Violation newViolation, Map<Violation, RuleFailureModel> violationMap) {
        return violationMap.get(newViolation) == null;
    }

    private RuleFailureModel findPastViolationWithSameLineAndMessage(Violation newViolation, Collection<RuleFailureModel> pastViolations) {
        for (RuleFailureModel pastViolation : pastViolations) {
            if (!this.isSameLine(newViolation, pastViolation) || !this.isSameMessage(newViolation, pastViolation)) continue;
            return pastViolation;
        }
        return null;
    }

    private RuleFailureModel findPastViolationWithSameChecksumAndMessage(Violation newViolation, Collection<RuleFailureModel> pastViolations) {
        for (RuleFailureModel pastViolation : pastViolations) {
            if (!this.isSameChecksum(newViolation, pastViolation) || !this.isSameMessage(newViolation, pastViolation)) continue;
            return pastViolation;
        }
        return null;
    }

    private RuleFailureModel findPastViolationWithSameLineAndChecksumAndMessage(Violation newViolation, Collection<RuleFailureModel> pastViolations) {
        for (RuleFailureModel pastViolation : pastViolations) {
            if (!this.isSameLine(newViolation, pastViolation) || !this.isSameChecksum(newViolation, pastViolation) || !this.isSameMessage(newViolation, pastViolation)) continue;
            return pastViolation;
        }
        return null;
    }

    private boolean isSameChecksum(Violation newViolation, RuleFailureModel pastViolation) {
        return pastViolation.getChecksum() != null && StringUtils.equals((String)pastViolation.getChecksum(), (String)this.getChecksumForLine(this.checksums, newViolation.getLineId()));
    }

    private boolean isSameLine(Violation newViolation, RuleFailureModel pastViolation) {
        if (pastViolation.getLine() == null && newViolation.getLineId() == null) {
            return true;
        }
        return ObjectUtils.equals((Object)pastViolation.getLine(), (Object)newViolation.getLineId());
    }

    private boolean isSameMessage(Violation newViolation, RuleFailureModel pastViolation) {
        return StringUtils.equals((String)RuleFailureModel.abbreviateMessage((String)newViolation.getMessage()), (String)pastViolation.getMessage());
    }

    private void mapViolation(Violation newViolation, RuleFailureModel pastViolation, Multimap<Integer, RuleFailureModel> pastViolationsByRule, Map<Violation, RuleFailureModel> violationMap) {
        if (pastViolation != null) {
            pastViolationsByRule.remove((Object)newViolation.getRule().getId(), (Object)pastViolation);
            violationMap.put(newViolation, pastViolation);
        }
    }

    private List<String> getChecksums(SnapshotSource source) {
        return source == null || source.getData() == null ? Collections.emptyList() : ViolationPersisterDecorator.getChecksums(source.getData());
    }

    static List<String> getChecksums(String data) {
        String[] lines = data.split("\r?\n|\r", -1);
        ArrayList result = Lists.newArrayList();
        for (String line : lines) {
            result.add(ViolationPersisterDecorator.getChecksum(line));
        }
        return result;
    }

    static String getChecksum(String line) {
        String reducedLine = StringUtils.replaceChars((String)line, (String)SPACE_CHARS, (String)"");
        return DigestUtils.md5Hex((String)reducedLine);
    }

    private String getChecksumForLine(List<String> checksums, Integer line) {
        if (line == null || line < 1 || line > checksums.size()) {
            return null;
        }
        return checksums.get(line - 1);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

