/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.components.PastMeasuresLoader;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.TimeMachineConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependedUpon(value={"END_OF_TIME_MACHINE"})
public class VariationDecorator
implements Decorator {
    private List<PastSnapshot> projectPastSnapshots;
    private MetricFinder metricFinder;
    private PastMeasuresLoader pastMeasuresLoader;

    public VariationDecorator(PastMeasuresLoader pastMeasuresLoader, MetricFinder metricFinder, TimeMachineConfiguration configuration) {
        this(pastMeasuresLoader, metricFinder, configuration.getProjectPastSnapshots());
    }

    public VariationDecorator(PastMeasuresLoader pastMeasuresLoader, MetricFinder metricFinder, List<PastSnapshot> projectPastSnapshots) {
        this.pastMeasuresLoader = pastMeasuresLoader;
        this.projectPastSnapshots = projectPastSnapshots;
        this.metricFinder = metricFinder;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.isLatestAnalysis();
    }

    @DependsUpon
    public Collection<Metric> dependsUponMetrics() {
        return this.pastMeasuresLoader.getMetrics();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (VariationDecorator.shouldCalculateVariations(resource)) {
            for (PastSnapshot projectPastSnapshot : this.projectPastSnapshots) {
                this.calculateVariation(resource, context, projectPastSnapshot);
            }
        }
    }

    static boolean shouldCalculateVariations(Resource resource) {
        return StringUtils.equals((String)"PRJ", (String)resource.getScope()) || StringUtils.equals((String)"DIR", (String)resource.getScope());
    }

    private void calculateVariation(Resource resource, DecoratorContext context, PastSnapshot pastSnapshot) {
        List pastMeasures = this.pastMeasuresLoader.getPastMeasures(resource, pastSnapshot);
        this.compareWithPastMeasures(context, pastSnapshot.getIndex(), pastMeasures);
    }

    void compareWithPastMeasures(DecoratorContext context, int index, List<Object[]> pastMeasures) {
        HashMap pastMeasuresByKey = Maps.newHashMap();
        for (Object[] pastMeasure : pastMeasures) {
            pastMeasuresByKey.put(new MeasureKey(pastMeasure), pastMeasure);
        }
        for (Measure measure : (Collection)context.getMeasures((MeasuresFilter)new CustomMeasureFilter())) {
            Integer characteristicId;
            Integer metricId = measure.getMetric().getId() != null ? measure.getMetric().getId() : this.metricFinder.findByKey(measure.getMetric().getKey()).getId();
            Integer n = characteristicId = measure.getCharacteristic() != null ? measure.getCharacteristic().getId() : null;
            Object[] pastMeasure = (Object[])pastMeasuresByKey.get(new MeasureKey(metricId, characteristicId));
            if (!this.updateVariation(measure, pastMeasure, index)) continue;
            context.saveMeasure(measure);
        }
    }

    boolean updateVariation(Measure measure, Object[] pastMeasure, int index) {
        if (pastMeasure != null && PastMeasuresLoader.hasValue((Object[])pastMeasure) && measure.getValue() != null) {
            double variation = measure.getValue() - PastMeasuresLoader.getValue((Object[])pastMeasure);
            measure.setVariation(index, Double.valueOf(variation));
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static final class MeasureKey {
        int metricId;
        Integer characteristicId;

        MeasureKey(Object[] pastFields) {
            this.metricId = PastMeasuresLoader.getMetricId((Object[])pastFields);
            this.characteristicId = PastMeasuresLoader.getCharacteristicId((Object[])pastFields);
        }

        MeasureKey(int metricId, Integer characteristicId) {
            this.metricId = metricId;
            this.characteristicId = characteristicId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MeasureKey that = (MeasureKey)o;
            if (this.metricId != that.metricId) {
                return false;
            }
            return !(this.characteristicId != null ? !this.characteristicId.equals(that.characteristicId) : that.characteristicId != null);
        }

        public int hashCode() {
            int result = this.metricId;
            result = 31 * result + (this.characteristicId != null ? this.characteristicId.hashCode() : 0);
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CustomMeasureFilter
    implements MeasuresFilter<Collection<Measure>> {
        CustomMeasureFilter() {
        }

        public Collection<Measure> filter(Collection<Measure> measures) {
            ArrayList result = Lists.newArrayList();
            for (Measure measure : measures) {
                if (measure instanceof RuleMeasure) continue;
                result.add(measure);
            }
            return result;
        }
    }
}

