/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.TimeMachineConfiguration;

public final class TimeMachineConfigurationPersister
implements Decorator {
    private TimeMachineConfiguration configuration;
    private Snapshot projectSnapshot;
    private DatabaseSession session;

    public TimeMachineConfigurationPersister(TimeMachineConfiguration configuration, Snapshot projectSnapshot, DatabaseSession session) {
        this.configuration = configuration;
        this.projectSnapshot = projectSnapshot;
        this.session = session;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (ResourceUtils.isProject((Resource)resource)) {
            this.persistConfiguration();
        }
    }

    void persistConfiguration() {
        List pastSnapshots = this.configuration.getProjectPastSnapshots();
        for (PastSnapshot pastSnapshot : pastSnapshots) {
            this.projectSnapshot = (Snapshot)this.session.reattach(Snapshot.class, (Object)this.projectSnapshot.getId());
            this.projectSnapshot.setPeriodMode(pastSnapshot.getIndex(), pastSnapshot.getMode());
            this.projectSnapshot.setPeriodModeParameter(pastSnapshot.getIndex(), pastSnapshot.getModeParameter());
            this.projectSnapshot.setPeriodDate(pastSnapshot.getIndex(), pastSnapshot.getTargetDate());
            this.session.save((Object)this.projectSnapshot);
        }
        this.session.commit();
    }

    public boolean shouldExecuteOnProject(Project project) {
        return true;
    }
}

