/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.TimeMachine;
import org.sonar.api.batch.TimeMachineQuery;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.plugins.core.timemachine.TendencyAnalyser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependedUpon(value={"END_OF_TIME_MACHINE"})
public class TendencyDecorator
implements Decorator {
    public static final String PROP_DAYS_DESCRIPTION = "Number of days the tendency should be calculated on.";
    private TimeMachine timeMachine;
    private TimeMachineQuery query;
    private TendencyAnalyser analyser;
    private TimeMachineConfiguration configuration;
    private List<Metric> metrics;

    public TendencyDecorator(TimeMachine timeMachine, MetricFinder metricFinder, TimeMachineConfiguration configuration) {
        this.timeMachine = timeMachine;
        this.analyser = new TendencyAnalyser();
        this.configuration = configuration;
        this.metrics = Lists.newLinkedList();
        for (Metric metric : metricFinder.findAll()) {
            if (!metric.isNumericType()) continue;
            this.metrics.add(metric);
        }
    }

    TendencyDecorator(TimeMachine timeMachine, TimeMachineQuery query, TendencyAnalyser analyser, TimeMachineConfiguration configuration) {
        this.timeMachine = timeMachine;
        this.query = query;
        this.analyser = analyser;
        this.configuration = configuration;
    }

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return this.metrics;
    }

    protected TimeMachineQuery initQuery(Project project) {
        int days = this.configuration.getTendencyPeriodInDays();
        this.query = new TimeMachineQuery(null).setFrom(DateUtils.addDays((Date)project.getAnalysisDate(), (int)(-days))).setToCurrentAnalysis(true).setMetrics(this.metrics);
        return this.query;
    }

    protected TimeMachineQuery resetQuery(Project project, Resource resource) {
        if (this.query == null) {
            this.initQuery(project);
        }
        this.query.setResource(resource);
        return this.query;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.configuration.skipTendencies();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(resource)) {
            this.resetQuery(context.getProject(), resource);
            List fields = this.timeMachine.getMeasuresFields(this.query);
            ArrayListMultimap valuesPerMetric = ArrayListMultimap.create();
            for (Object[] field : fields) {
                valuesPerMetric.put((Object)((Metric)field[1]), (Object)((Double)field[2]));
            }
            for (Metric metric : this.query.getMetrics()) {
                Measure measure = context.getMeasure(metric);
                if (measure == null) continue;
                List values = valuesPerMetric.get((Object)metric);
                values.add(measure.getValue());
                measure.setTendency(this.analyser.analyseLevel(valuesPerMetric.get((Object)metric)));
                context.saveMeasure(measure);
            }
        }
    }

    private boolean shouldDecorateResource(Resource resource) {
        return StringUtils.equals((String)"PRJ", (String)resource.getScope()) || StringUtils.equals((String)"DIR", (String)resource.getScope());
    }
}

