/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TendencyAnalyser {
    public static final Integer TENDENCY_BIG_UP = 2;
    public static final Integer TENDENCY_UP = 1;
    public static final Integer TENDENCY_NEUTRAL = 0;
    public static final Integer TENDENCY_DOWN = -1;
    public static final Integer TENDENCY_BIG_DOWN = -2;

    public Integer analyseLevel(List<Double> values) {
        SlopeData slopeData = this.analyse(values);
        if (slopeData != null) {
            return slopeData.getLevel();
        }
        return null;
    }

    public SlopeData analyse(List<Double> values) {
        double sumY = 0.0;
        double sumX = 0.0;
        double sumYPower2 = 0.0;
        double sumXY = 0.0;
        double sumXPower2 = 0.0;
        int nbrPoints = 0;
        boolean nullValuesYList = true;
        int i = 0;
        for (Double p : values) {
            if (p != null) {
                nullValuesYList = false;
                sumY += p.doubleValue();
                sumYPower2 += p * p;
                sumXY += p * (double)(i + 1);
                sumX += (double)(i + 1);
                sumXPower2 += (double)((i + 1) * (i + 1));
                ++nbrPoints;
            }
            ++i;
        }
        if (nullValuesYList || nbrPoints == 1) {
            return null;
        }
        double n0 = (double)nbrPoints * sumXY - sumX * sumY;
        double d = (double)nbrPoints * sumXPower2 - sumX * sumX;
        double n1 = sumY * sumXPower2 - sumX * sumXY;
        SlopeData result = new SlopeData();
        result.setYIntercept(n1 / d);
        if (n0 == 0.0 && d == 0.0) {
            result.setSlope(0.0);
        } else {
            Double slope = n0 / d;
            if (Double.isNaN(slope) || Double.isInfinite(slope)) {
                result.setSlope(null);
            } else {
                result.setSlope(slope);
            }
        }
        result.setSumXPower2(sumXPower2);
        result.setSumXY(sumXY);
        result.setSumYPower2(sumYPower2);
        if (sumXPower2 == 0.0 || sumYPower2 == 0.0) {
            result.setCorrelationRate(0.0);
        } else {
            result.setCorrelationRate(sumXY / Math.sqrt(sumXPower2 * sumYPower2));
        }
        return result;
    }

    static class SlopeData {
        private double sumXPower2;
        private double sumYPower2;
        private double sumXY;
        private double yIntercept;
        private Double slope;
        private Double correlationRate;

        SlopeData() {
        }

        public double getSumXPower2() {
            return this.sumXPower2;
        }

        public void setSumXPower2(double sumXPower2) {
            this.sumXPower2 = sumXPower2;
        }

        public double getSumYPower2() {
            return this.sumYPower2;
        }

        public void setSumYPower2(double sumYPower2) {
            this.sumYPower2 = sumYPower2;
        }

        public double getSumXY() {
            return this.sumXY;
        }

        public void setSumXY(double sumXY) {
            this.sumXY = sumXY;
        }

        public double getYIntercept() {
            return this.yIntercept;
        }

        public void setYIntercept(double yIntercept) {
            this.yIntercept = yIntercept;
        }

        public Double getSlope() {
            return this.slope;
        }

        public void setSlope(Double slope) {
            this.slope = slope;
        }

        public Double getCorrelationRate() {
            return this.correlationRate;
        }

        public void setCorrelationRate(Double correlationRate) {
            this.correlationRate = correlationRate;
        }

        public Integer getLevel() {
            boolean vHCorCoefNeg;
            double hSlope = 0.8;
            double nSlope = 0.2;
            double vHighCorcoef = 1.0;
            double modCorcoef = 0.69;
            Double correlationCoeff = this.getCorrelationRate();
            boolean vHCorCoefPos = correlationCoeff > modCorcoef && correlationCoeff <= vHighCorcoef;
            boolean bl = vHCorCoefNeg = correlationCoeff < -modCorcoef && correlationCoeff >= -vHighCorcoef;
            if ((vHCorCoefPos || vHCorCoefNeg) && this.slope >= hSlope) {
                return TENDENCY_BIG_UP;
            }
            if ((vHCorCoefPos || vHCorCoefNeg) && this.slope <= -hSlope) {
                return TENDENCY_BIG_DOWN;
            }
            if ((vHCorCoefPos || vHCorCoefNeg) && this.slope >= nSlope && this.slope < hSlope) {
                return TENDENCY_UP;
            }
            if ((vHCorCoefPos || vHCorCoefNeg) && this.slope <= -nSlope && this.slope > -hSlope) {
                return TENDENCY_DOWN;
            }
            if ((vHCorCoefPos || vHCorCoefNeg) && (this.slope < nSlope || this.slope > -nSlope)) {
                return TENDENCY_NEUTRAL;
            }
            if (correlationCoeff == 0.0 && this.slope == 0.0 && !vHCorCoefPos && !vHCorCoefNeg) {
                return TENDENCY_NEUTRAL;
            }
            return null;
        }
    }
}

