/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.core.timemachine;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.Violation;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.TimeMachineConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DependsUpon(value={"END_OF_VIOLATION_TRACKING"})
public class NewViolationsDecorator
implements Decorator {
    private TimeMachineConfiguration timeMachineConfiguration;
    private Map<Rule, RulePriority> ruleToLevel = Maps.newHashMap();
    private Multimap<RulePriority, Violation> violationsBySeverity = ArrayListMultimap.create();
    private Multimap<Rule, Violation> violationsByRule = ArrayListMultimap.create();

    public NewViolationsDecorator(TimeMachineConfiguration timeMachineConfiguration) {
        this.timeMachineConfiguration = timeMachineConfiguration;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return project.isLatestAnalysis();
    }

    @DependedUpon
    public List<Metric> generatesMetric() {
        return Arrays.asList(CoreMetrics.NEW_VIOLATIONS, CoreMetrics.NEW_BLOCKER_VIOLATIONS, CoreMetrics.NEW_CRITICAL_VIOLATIONS, CoreMetrics.NEW_MAJOR_VIOLATIONS, CoreMetrics.NEW_MINOR_VIOLATIONS, CoreMetrics.NEW_INFO_VIOLATIONS);
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorateResource(resource, context)) {
            this.prepareCurrentResourceViolations(context);
            this.saveNewViolations(context);
            this.saveNewViolationsBySeverity(context);
            this.saveNewViolationsByRule(context);
            this.clearCache();
        }
    }

    private boolean shouldDecorateResource(Resource resource, DecoratorContext context) {
        return (StringUtils.equals((String)"PRJ", (String)resource.getScope()) || StringUtils.equals((String)"DIR", (String)resource.getScope()) || StringUtils.equals((String)"FIL", (String)resource.getScope())) && !ResourceUtils.isUnitTestClass((Resource)resource) && context.getMeasure(CoreMetrics.NEW_VIOLATIONS) == null;
    }

    private void clearCache() {
        this.ruleToLevel.clear();
        this.violationsBySeverity.clear();
        this.violationsByRule.clear();
    }

    private void prepareCurrentResourceViolations(DecoratorContext context) {
        for (Violation violation : context.getViolations()) {
            this.violationsBySeverity.put((Object)violation.getSeverity(), (Object)violation);
            this.violationsByRule.put((Object)violation.getRule(), (Object)violation);
            this.ruleToLevel.put(violation.getRule(), violation.getSeverity());
        }
    }

    private void saveNewViolations(DecoratorContext context) {
        Measure measure = new Measure(CoreMetrics.NEW_VIOLATIONS);
        for (PastSnapshot pastSnapshot : this.timeMachineConfiguration.getProjectPastSnapshots()) {
            int variationIndex = pastSnapshot.getIndex();
            Collection children = context.getChildrenMeasures(CoreMetrics.NEW_VIOLATIONS);
            int count = this.countViolations(context.getViolations(), pastSnapshot.getTargetDate());
            double sum = this.sumChildren(variationIndex, children) + count;
            measure.setVariation(variationIndex, Double.valueOf(sum));
        }
        context.saveMeasure(measure);
    }

    private void saveNewViolationsBySeverity(DecoratorContext context) {
        for (RulePriority priority : RulePriority.values()) {
            Metric metric = this.getMetricForSeverity(priority);
            Measure measure = new Measure(metric);
            for (PastSnapshot pastSnapshot : this.timeMachineConfiguration.getProjectPastSnapshots()) {
                int variationIndex = pastSnapshot.getIndex();
                int count = this.countViolations(this.violationsBySeverity.get((Object)priority), pastSnapshot.getTargetDate());
                Collection children = context.getChildrenMeasures(MeasuresFilters.metric((Metric)metric));
                double sum = this.sumChildren(variationIndex, children) + count;
                measure.setVariation(variationIndex, Double.valueOf(sum));
            }
            context.saveMeasure(measure);
        }
    }

    private void saveNewViolationsByRule(DecoratorContext context) {
        ArrayListMultimap childrenByRule = ArrayListMultimap.create();
        Collection children = context.getChildrenMeasures(MeasuresFilters.rules((Metric)CoreMetrics.NEW_VIOLATIONS));
        for (Measure childMeasure : children) {
            RuleMeasure childRuleMeasure = (RuleMeasure)childMeasure;
            Rule rule = childRuleMeasure.getRule();
            if (rule == null) continue;
            childrenByRule.put((Object)rule, (Object)childMeasure);
            this.ruleToLevel.put(childRuleMeasure.getRule(), childRuleMeasure.getRulePriority());
        }
        HashSet rules = Sets.newHashSet((Iterable)this.violationsByRule.keys());
        rules.addAll(childrenByRule.keys());
        for (Rule rule : rules) {
            RuleMeasure measure = RuleMeasure.createForRule((Metric)CoreMetrics.NEW_VIOLATIONS, (Rule)rule, null);
            measure.setRulePriority(this.ruleToLevel.get(rule));
            for (PastSnapshot pastSnapshot : this.timeMachineConfiguration.getProjectPastSnapshots()) {
                int variationIndex = pastSnapshot.getIndex();
                int count = this.countViolations(this.violationsByRule.get((Object)rule), pastSnapshot.getTargetDate());
                double sum = this.sumChildren(variationIndex, childrenByRule.get((Object)rule)) + count;
                measure.setVariation(variationIndex, Double.valueOf(sum));
            }
            context.saveMeasure((Measure)measure);
        }
    }

    int sumChildren(int variationIndex, Collection<Measure> measures) {
        int sum = 0;
        for (Measure measure : measures) {
            Double var = measure.getVariation(variationIndex);
            if (var == null) continue;
            sum += var.intValue();
        }
        return sum;
    }

    int countViolations(Collection<Violation> violations, Date targetDate) {
        if (violations == null) {
            return 0;
        }
        int count = 0;
        for (Violation violation : violations) {
            if (!this.isAfter(violation, targetDate)) continue;
            ++count;
        }
        return count;
    }

    private boolean isAfter(Violation violation, Date date) {
        return violation.getCreatedAt() != null && violation.getCreatedAt().after(date);
    }

    private Metric getMetricForSeverity(RulePriority severity) {
        Metric metric;
        if (severity.equals((Object)RulePriority.BLOCKER)) {
            metric = CoreMetrics.NEW_BLOCKER_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.CRITICAL)) {
            metric = CoreMetrics.NEW_CRITICAL_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.MAJOR)) {
            metric = CoreMetrics.NEW_MAJOR_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.MINOR)) {
            metric = CoreMetrics.NEW_MINOR_VIOLATIONS;
        } else if (severity.equals((Object)RulePriority.INFO)) {
            metric = CoreMetrics.NEW_INFO_VIOLATIONS;
        } else {
            throw new IllegalArgumentException("Not supported severity: " + severity);
        }
        return metric;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

